# CVE-2025-22235: Spring Boot EndpointRequest.to() 认证绕过漏洞演示

## 漏洞描述

CVE-2025-22235是一个Spring Boot安全漏洞，涉及`EndpointRequest.to()`方法在配置安全规则时可能生成错误的匹配器，导致未暴露的执行器端点路径（如`/null/**`）的安全保护失效。

## 影响版本

- Spring Security 5.7.16
- Spring Security 5.8.18  
- Spring Security 6.0.16
- Spring Security 6.1.14
- Spring Security 6.2.10
- Spring Security 6.3.8
- Spring Security 6.4.4
- 较旧的、不受支持的版本也受到影响

## 漏洞原理

当使用`EndpointRequest.to("health")`配置安全规则时，如果`health`端点未在`management.endpoints.web.exposure.include`中配置，Spring Boot会生成错误的路径匹配器`/null/**`，导致该路径下的所有请求都绕过认证检查。

## 环境搭建

### 1. 项目依赖
- Spring Boot 3.4.3 (有漏洞版本)
- Spring Security
- Spring Boot Actuator

### 2. 关键配置
- `management.endpoints.web.exposure.include=info` (仅暴露info端点，health端点未暴露)
- 安全配置中使用`EndpointRequest.to("health")`引用未暴露的端点

## 漏洞复现步骤

### 1. 启动应用
```bash
mvn spring-boot:run
```

### 2. 访问受保护的端点
直接访问 `http://localhost:8080/null`，无需登录即可访问，证明存在认证绕过漏洞。

### 3. 正常认证流程
访问其他受保护的端点如 `http://localhost:8080/info`，会要求登录。

## 漏洞代码分析

### 安全配置类 (SecurityConfig.java)
```java
.requestMatchers(EndpointRequest.to("health")).permitAll()  // 漏洞触发点
.requestMatchers("/null").authenticated()                   // 应该受保护但被绕过
```

### 控制器 (DemoController.java)
```java
@GetMapping("/null")
public String sensitiveEndpoint() {
    return "未登录看到此页面，说明存在CVE-2025-22235认证绕过漏洞!";
}
```

## 漏洞修复

### 1. 升级Spring Boot版本
升级到以下修复版本：
- 3.4.5+
- 3.3.11+
- 其他受支持的最新版本

### 2. 临时缓解措施
- 确保`EndpointRequest.to()`所指的端点已启用并通过Web公开
- 避免处理`/null`路径的请求
- 检查安全配置中引用的端点是否都已正确暴露

## 技术细节

漏洞的根本原因在于`EndpointRequest.to()`方法在处理未暴露的端点时，会生成错误的路径匹配器。当端点名称在`management.endpoints.web.exposure.include`中未配置时，Spring Boot会创建一个包含`null`的路径模式，导致安全规则失效。

## 参考资料

- [CVE-2025-22235官方公告](https://forum.butian.net/article/706)
- Spring Boot官方安全公告
- Spring Security官方文档

## 免责声明

本演示项目仅用于安全研究和教育目的，请勿在生产环境中使用。使用本项目的风险由使用者自行承担。




