# CVE-2025-21202-exploit
CVE-2025-12101 is a cross-site scripting (XSS) vulnerability impacting Citrix NetScaler ADC and Citrix NetScaler Gateway appliances when configured in certain roles (Gateway, AAA virtual server)
# CVE-2025-12101 – Reflected XSS Detection Tool  
![Python](https://img.shields.io/badge/Python-3.7%2B-blue)
![Status](https://img.shields.io/badge/Project-PoC-orange)
![Security](https://img.shields.io/badge/Security-Research%20Only-red)

A proof-of-concept Python tool for identifying reflected Cross-Site Scripting (XSS) in Citrix NetScaler ADC / Gateway appliances affected by **CVE-2025-12101**.

This script sends a crafted SAMLResponse payload via a raw POST request to `/cgi/logout` and analyzes the server's response for reflected JavaScript code.

---

## 🔥 Features

- 🔍 Detects reflection of `<script>alert(1)</script>`
- 📡 Sends raw HTTP request (no external libraries used)
- 🔐 Full HTTPS (SSL/TLS) support
- 🎨 Color-coded CLI output
- 🧪 Optional flag to display **final sent request** and **server response**
- ⚡ Fast — built only on the Python standard library

---

## 📦 Installation

Clone the repository:

```bash
git clone https://github.com/yourname/CVE-2025-12101-Scanner.git
cd CVE-2025-12101-Scanner
python3 CVE-2025-12101-Scanner.py -u <url> --show #to show the request and response

