# CVE-2025-2082 – Function Pointer Overwrite PoV (VCSEC-style)

This repository demonstrates a Proof of Vulnerability (PoV) simulating a critical memory corruption flaw inspired by [CVE-2025-2082](https://nvd.nist.gov/vuln/detail/CVE-2025-2082), discovered in Tesla's **VCSEC** (Vehicle Controller Security) component.

The vulnerability allows an attacker to overwrite a **function pointer** by exploiting a signed-to-unsigned integer conversion bug and improper memory bounds validation during a `memcpy()` operation.

---

## What This PoV Demonstrates

- How using a negative `startIndex` in a BLE message can cause memory to be written **before the start of a buffer**
- How that memory region may contain a critical **function pointer**
- How overwriting that pointer leads to arbitrary code execution

---

## Structure of the C Code

```c
struct VCSEC {
    void (*func_ptr)();              // Function pointer to be hijacked
    uint8_t g_cert_buffer[1024];     // Target buffer for certificate data
};
