#!/bin/bash

# Installer script for the vulnerable Depicter plugin
# This script uses Docker commands to install the plugin directly into the WordPress container

echo "Installing Depicter Plugin v3.6.1 (vulnerable version)..."

# Check if the WordPress container is running
if ! docker-compose ps | grep -q "wordpress.*Up"; then
    echo "Error: WordPress container is not running!"
    echo "Please start the environment with: docker-compose up -d"
    exit 1
fi

# Install WP-CLI if not already installed
echo "Setting up WP-CLI in the WordPress container..."
docker-compose exec wordpress bash -c "
    if ! command -v wp &> /dev/null; then
        curl -O https://raw.githubusercontent.com/wp-cli/builds/gh-pages/phar/wp-cli.phar
        chmod +x wp-cli.phar
        mv wp-cli.phar /usr/local/bin/wp
    fi
"

# Check if WordPress is installed
echo "Checking WordPress installation status..."
IS_WP_INSTALLED=$(docker-compose exec -T wordpress bash -c "cd /var/www/html && wp core is-installed --allow-root 2>/dev/null && echo 1 || echo 0")

if [ "$IS_WP_INSTALLED" -eq "0" ]; then
    echo "WordPress is not yet installed. Please complete the installation in your browser:"
    echo "http://localhost:5555"
    echo ""
    echo "After installation is complete, run this script again."
    exit 1
fi

# Install required packages
echo "Installing required packages..."
docker-compose exec wordpress bash -c "
    apt-get update && 
    apt-get install -y wget unzip net-tools
"

# Download and install the plugin
echo "Downloading and installing the Depicter plugin..."
docker-compose exec wordpress bash -c "
    cd /var/www/html/wp-content/plugins/ && 
    wget -q https://downloads.wordpress.org/plugin/depicter.3.6.1.zip && 
    unzip -q depicter.3.6.1.zip && 
    rm depicter.3.6.1.zip
"

# Activate the plugin
echo "Activating the plugin..."
docker-compose exec wordpress bash -c "
    cd /var/www/html && 
    wp plugin activate depicter --allow-root
"

# Verify installation
echo "Verifying plugin installation..."
PLUGIN_STATUS=$(docker-compose exec -T wordpress bash -c "cd /var/www/html && wp plugin list --allow-root | grep depicter")
CONTAINER_IP=$(docker-compose exec -T wordpress bash -c "hostname -I | awk '{print \$1}'")

if echo "$PLUGIN_STATUS" | grep -q "active"; then
    echo "✅ Success! The vulnerable Depicter plugin (v3.6.1) has been installed and activated."
    echo ""
    echo "You can now test the SQL injection vulnerability:"
    echo "python poc.py -u http://$CONTAINER_IP -d"
else
    echo "⚠️ Warning: Plugin was installed but may not be activated properly." 
    echo "Please check the WordPress admin panel at: http://$CONTAINER_IP/wp-admin"
    echo "Go to Plugins and make sure Depicter is activated."
fi
