{
  description = "Environment for exploiting CVE-2025-1910";

  inputs = {
    nixpkgs.url = "github:nixos/nixpkgs/nixos-unstable";
    flake-utils.url = "github:numtide/flake-utils";
  };

  outputs = {
    self,
    nixpkgs,
    flake-utils,
  }:
    flake-utils.lib.eachDefaultSystem (system: let
      pkgs = import nixpkgs {inherit system;};
    in {
      devShells.default = pkgs.mkShell {
        # The packages to include in the environment
        buildInputs = [
          (pkgs.python3.withPackages (python-pkgs: [
            # Add flask to the Python environment
            python-pkgs.flask
          ]))

          # Add openssl, openvpn and coreutils (md5sum) as dependencies
          pkgs.openssl
          pkgs.openvpn
          pkgs.coreutils
        ];
      };

      # Formatting with alejandra via `nix fmt .`
      formatter = pkgs.alejandra;
    });
}
