#!/usr/bin/env bash
set -euo pipefail

need_cmd() { command -v "$1" >/dev/null 2>&1; }

if ! need_cmd docker; then
  echo "Docker is not installed."
  exit 1
fi

COMPOSE="docker compose"
if ! $COMPOSE version >/dev/null 2>&1; then
  if need_cmd docker-compose; then
    COMPOSE="docker-compose"
  else
    echo "I can't find docker compose."
    exit 1
  fi
fi

if need_cmd ss; then
  if ss -ltn 2>/dev/null | grep -q ':80 '; then
    echo "Port 80 is already in use. Free up port 80 and run again."
    exit 1
  fi
elif need_cmd lsof; then
  if lsof -iTCP:80 -sTCP:LISTEN >/dev/null 2>&1; then
    echo "Port 80 is already in use. Free up port 80 and run again."
    exit 1
  fi
fi

mkdir -p data
chmod 777 data

if [[ "${EUID:-$(id -u)}" -ne 0 ]]; then
  echo "I need privileges to bind to port 80. I'll use sudo."
  sudo $COMPOSE up --build -d
else
  $COMPOSE up --build -d
fi

echo "OK. Listening on http://<HOST_IP>/"
echo "Logs at ./data/scan.log"

