# CVE-2025-1868: Advanced IP Scanner & Advanced Port Scanner NTLM Leakage HTTP Tester

Small dockerized PHP app that triggers an NTLM handshake and extracts the claimed **domain**, **user**, and **workstation** from NTLM Type 3 messages.

It does not validate passwords.  
It does not store challenges.  
It only logs claimed identity and request metadata.

This is useful to confirm when a scanner or troubleshooting workflow is causing outbound NTLM authentication over HTTP.

**Important:** Must be published on **host port 80**. If you publish it on a different port, validation may fail.

**+Info:** [https://labs.itresit.es/2026/01/03/cve-2025-1868-unpatched-advanced-ip-scanner-silently-exposes-ntlm-during-scans/](https://labs.itresit.es/2026/01/07/cve-2025-1868-unpatched-advanced-ip-scanner-silently-exposes-ntlm-during-scans/)

### 1. Running in docker mode
```bash
./run.sh
```
#### Logs
```bash
tail -f data/scan.log
```
### 2. Standalone deployment

`src/index.php` is fully self-contained and can run as a standalone endpoint on **any web server that can execute PHP** (e.g., Apache + mod_php, Nginx + PHP-FPM, ...).

#### Quick start for standalone deployments
1. Copy `index.php` to your web root (or to a dedicated virtual host), for example:
   - `Apache`: `/var/www/html/index.php`
   - `Nginx`: your site root, served via PHP-FPM

2. Ensure the process user can write the log file (default: `../scan.log`)

### 3. References
- https://nvd.nist.gov/vuln/detail/CVE-2025-1868
- https://www.cve.org/CVERecord?id=2025-1868
- https://www.incibe.es/incibe-cert/alerta-temprana/vulnerabilidades/cve-2025-1868
- https://labs.itresit.es/published-vulnerabilities/
