# 🔓 Exploit Script for CVE-2025-1639

## 📝 Description

The Animation Addons for Elementor Pro plugin for WordPress is vulnerable to unauthorized arbitrary plugin installation due to a missing capability check on the `install_elementor_plugin_handler()` function in all versions up to, and including, 1.6. This makes it possible for authenticated attackers, with Subscriber-level access and above, to install and activate arbitrary plugins which can be leveraged to further infect a victim when Elementor is not activated on a vulnerable site.

### 🔍 Vulnerability Details
- **CVE ID:** CVE-2025-1639
- **Published:** 2025-03-04
- **Updated:** 2025-03-04
- **CWE:** [CWE-862: Missing Authorization](https://cwe.mitre.org/data/definitions/862.html)
- **CVSS Score:** 8.8 (HIGH)
- **CVSS Vector:** CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H

## 🚀 Features of the Exploit Script
- **🔐 Automated Login:** The script automates the login process to the target WordPress site.
- **🔎 Version Check:** Checks if the target site is running a vulnerable version of the plugin.
- **🛡️ Security Token Extraction:** Extracts the security nonce required for exploiting the vulnerability.
- **📦 Plugin Installation and Activation:** Installs and activates an arbitrary plugin specified by the user.

## 🛠️ Usage

### 📋 Prerequisites
- Python 3.x
- `requests` library
- `BeautifulSoup` library

### 📥 Installation
1. Clone the repository:
    ```bash
    git clone https://github.com/Nxploited/CVE-2025-1639.git
    ```
2. Navigate to the directory:
    ```bash
    cd CVE-2025-1639
    ```
3. Install the required libraries:
    ```bash
    pip install -r requirements.txt
    ```

### 🏃 Running the Script
```bash
usage: CVE-2025-1639.py [-h] -u URL -un USERNAME -p PASSWORD [-pl PLUGIN]

Exploit script for CVE-2025-1639 # By Nxploit | Kaled ALenazi

options:
  -h, --help            show this help message and exit
  -u URL, --url URL     Target URL
  -un USERNAME, --username USERNAME
                        WordPress username
  -p PASSWORD, --password PASSWORD
                        WordPress password
  -pl PLUGIN, --plugin PLUGIN
                        Plugin slug to upload and activate (default: wp-maintenance-mode)
```

### ⚙️ Options
- `-u`, `--url`: Target URL
- `-un`, `--username`: WordPress username
- `-p`, `--password`: WordPress password
- `-pl`, `--plugin` (optional): Plugin slug to upload and activate (default: wp-maintenance-mode)

### 💡 Example
```bash
python CVE-2025-1639.py -u http://example.com/wordpress -un admin -p password -pl wp-maintenance-mode
```

## 📤 Output
- `Logged in successfully.`: Indicates successful login.
- `The site is vulnerable... Exploiting and uploading the plugin.`: Indicates the target site is vulnerable and the exploit is in progress.
- `Plugin uploaded and activated successfully.`: Indicates the plugin has been successfully uploaded and activated.
- `Failed to log in.`: Indicates login failure.
- `The site is not vulnerable.`: Indicates the target site is not running a vulnerable version.
- `Failed to extract security token.`: Indicates failure in extracting the security token required for exploitation.
- `Failed to upload and activate the plugin.`: Indicates failure in uploading and activating the plugin.

## ⚠️ Disclaimer
This script is for educational purposes only. Use it at your own risk. The author is not responsible for any damage caused by this script.

- **Khaled Alenazi (Nxploit)**
