# CVE-2025-15467

Stack buffer overflow in OpenSSL CMS AuthEnvelopedData parsing.

## Vulnerability

A stack buffer overflow exists in `evp_cipher_get_asn1_aead_params()` when parsing AEAD cipher parameters (e.g., AES-GCM) in CMS AuthEnvelopedData content. An oversized IV overflows a 16-byte stack buffer, allowing denial of service and potentially remote code execution.

### Affected Versions

| Branch | Vulnerable | Fixed |
|--------|------------|-------|
| 3.6.x  | 3.6.0      | 3.6.1+ |
| 3.5.x  | 3.5.0-3.5.4 | 3.5.5+ |
| 3.4.x  | 3.4.0-3.4.3 | 3.4.4+ |
| 3.3.x  | 3.3.0-3.3.5 | 3.3.6+ |
| 3.0.x  | 3.0.0-3.0.18 | 3.0.19+ |

OpenSSL 1.x is not affected.

## Files

```
.
├── README.md
├── dos.py                    # DoS exploit
└── vulnerable_service/
    ├── Dockerfile            # Builds vulnerable test service
    ├── entrypoint.sh         # Container entrypoint
    └── cms_server.c          # Vulnerable HTTP CMS parser
```

## Usage

### 1. Start Vulnerable Service

```bash
cd vulnerable_service
docker build -t vuln-cms .
docker run --rm -p 8080:8080 --privileged vuln-cms
```

### 2. Run DoS Exploit

```bash
python3 dos.py <host> <port>

# Example:
python3 dos.py localhost 8080
```

## References

- [OpenSSL Security Advisory](https://www.openssl.org/news/secadv/20250220.txt)
- [Fix Commit](https://github.com/openssl/openssl/commit/2c8f0e5fa9b6ee5508a0349e4572ddb74db5a703)
