# CVE-2025-15368 Exploit Tool
## SportsPress Plugin for WordPress (<= 2.7.26) - LFI & RCE

**Author:** kazehere4you  
**Date:** 2026-02-11

### Description
This tool exploits a **Local File Inclusion (LFI)** vulnerability in the SportsPress plugin for WordPress (versions up to and including 2.7.26). By leveraging the `[event_list]` shortcode and manipulating the `template_name` attribute, an authenticated attacker (Contributor+) can include arbitrary files.

Furthermore, this tool includes a chain to achieve **Remote Code Execution (RCE)** by uploading a malicious image file and including it via the LFI vulnerability (requires Author+ privileges for file upload).

### Features
*   **LFI Mode:** Automatically detects traversal depth and leaks sensitive files (e.g., `/etc/passwd`).
*   **RCE Mode:** Automates malicious file upload, nonce retrieval, and command execution.
*   **Smart Detection:** Handles different nonce locations (`media-new.php`, `upload.php`) and dynamic paths.

### Usage

#### Prerequisites
*   Python 3.x
*   `requests` library (`pip install requests`)
*   Valid WordPress credentials (Contributor role or higher)

#### 1. Local File Inclusion (LFI)
Leak `/etc/passwd` or other system files:
```bash
python CVE-2025-15368_Exploit.py -u http://target.com -user hacker -p password --lfi /etc/passwd
```

#### 2. Remote Code Execution (RCE)
Execute system commands (requires Author role):
```bash
python CVE-2025-15368_Exploit.py -u http://target.com -user hacker -p password --rce "id"
```

### Disclaimer
This tool is for educational purposes and authorized security testing only. The author is not responsible for any misuse of this software. Use it only on systems you own or have explicit permission to test.
