#!/usr/bin/env python3
"""
Script de Carga para Popular Heap do MongoDB
Executa queries massivas para garantir que tokens R6 fiquem residentes na memória
"""

import subprocess
import time
import sys

def executar_queries(num_queries=100):
    """Executa queries massivas para popular a heap"""
    print(f"[*] Executando {num_queries} queries para popular heap...")
    
    for i in range(num_queries):
        # Query 1: Buscar todos os tokens de servidor
        cmd1 = 'docker exec cve-2025-14847-lab mongosh r6_custom_matchmaking --quiet --eval "db.active_sessions.find({}, {serverAuthToken: 1}).toArray()"'
        
        # Query 2: Buscar jogadores com flags
        cmd2 = 'docker exec cve-2025-14847-lab mongosh r6_custom_matchmaking --quiet --eval "db.player_stats.find({internal_flags: {\\$ne: []}}).toArray()"'
        
        # Query 3: Config com API keys
        cmd3 = 'docker exec cve-2025-14847-lab mongosh r6_custom_matchmaking --quiet --eval "db.system_config.find().toArray()"'
        
        try:
            subprocess.run(cmd1, shell=True, stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL, timeout=2)
            subprocess.run(cmd2, shell=True, stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL, timeout=2)
            subprocess.run(cmd3, shell=True, stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL, timeout=2)
            
            if (i + 1) % 10 == 0:
                print(f"  → {i + 1}/{num_queries} queries executadas")
                
        except Exception as e:
            print(f"  [!] Erro na query {i}: {e}")
            continue
    
    print(f"[+] {num_queries} queries completas - heap POPULADA!")

if __name__ == "__main__":
    num = int(sys.argv[1]) if len(sys.argv) > 1 else 100
    executar_queries(num)
