# CVE-2025-14847 Reference Materials

## Official Vendor Advisories
- **MongoDB Security Advisory**: [GitHub Commit](https://github.com/mongodb/mongo/commit/1264f9be5165abb0981f8023d2495652ab916699#diff-fd797e63d8e20a16cf0adcb6b5542f2124de9bf6f3afa913ba8d09d3022b11ac)  
  *Direct patch for the vulnerability in zlib decompression logic*

## Incident Analysis & Threat Intelligence
- **SantoTech BR**: [R6 Attack Attribution](https://santotech.com.br/vulnerabilidade-no-mongodb-entra-no-radar-como-possivel-causa-do-ataque-ao-rainbow-six-siege/)  
  *Portuguese analysis linking MongoBleed to Rainbow Six Siege incident*

## Deep Technical Analysis
- **Akamai SIRT**: [All You Need to Know About MongoBleed](https://www.akamai.com/blog/security-research/cve-2025-14847-all-you-need-to-know-about-mongobleed)  
  *Comprehensive breakdown of exploitation mechanics and impact*

- **Aikido Security**: [Vulnerability Deep Dive](https://www.aikido.dev/blog/mongobleed-mongodb-zlib-vulnerability-cve-2025-14847)  
  *Technical proof-of-concept details and affected versions*

## Vulnerability Timeline
- **2025-12-20**: Rainbow Six Siege incident (unconfirmed root cause at time)
- **2025-12-28**: MongoDB confirms CVE-2025-14847 in internal testing
- **2026-01-02**: Public disclosure + patches released (6.0.27, 7.0.28, 8.0.17)
- **2026-01-03**: Akamai/Aikido publish technical analysis
- **2026-01-04**: This PoC development

## Affected Versions
All MongoDB versions with zlib compression enabled:
- **6.0.x** < 6.0.27
- **7.0.x** < 7.0.28  
- **8.0.x** < 8.0.17
- **8.2.x** < 8.2.3
- Legacy: 5.0.x, 4.4.x, 4.2.x, 4.0.x, 3.6.x (all versions vulnerable)

## Detection & Defense
- IDS Signature: Abnormal `OP_COMPRESSED` length fields (uncompressedSize > 10MB)
- Mitigation: Disable zlib (`net.compression.compressors: []`)
- Permanent Fix: Upgrade to patched versions
