// MongoDB R6 Simulation - MASSIVE DATA (1000+ records)
// Versão otimizada para maximizar presença de tokens na heap

db = db.getSiblingDB('r6_custom_matchmaking');

db.player_stats.drop();
db.active_sessions.drop();
db.system_config.drop();

print("[*] Gerando 1000 jogadores com tokens...");

// Gerar 1000 jogadores
const players = [];
for (let i = 0; i < 1000; i++) {
    players.push({
        platformId: `uplay-${i.toString(36)}-${Math.random().toString(36).substr(2, 8)}`,
        profileId: `${i.toString(16).padStart(8, '0')}-${Math.random().toString(16).substr(2, 4)}-4${Math.random().toString(16).substr(2, 3)}-${Math.random().toString(16).substr(2, 4)}-${Math.random().toString(16).substr(2, 12)}`,
        username: `ProPlayer_${i.toString().padStart(4, '0')}`,
        mmr: 2000 + Math.floor(Math.random() * 3000),
        region: ["brazilsouth", "us-east", "eu-west"][i % 3],
        team: i < 50 ? ["W7M", "FaZe", "Liquid", "G2", "FURIA"][i % 5] : null,
        internal_flags: i < 100 ? ["PRO_LEAGUE", "DEV_WHITELIST", "ADMIN"][i % 3] : [],

        // JWT com profileId embedado
        auth_token: `eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VyX2lkIjoiJHtpfSIsImdhbWUiOiJyNnMiLCJleHAiOjE3Mzk1OTk5OTl9.SIG${Math.random().toString(36).substr(2, 30)}`,

        client_ip: `10.${Math.floor(Math.random() * 255)}.${Math.floor(Math.random() * 255)}.${Math.floor(i / 4)}`
    });
}

db.player_stats.insertMany(players);
print(`[+] ${players.length} jogadores inseridos`);

print("[*] Gerando 500 sessões ativas com tokens R6...");

// Gerar 500 sessões
const sessions = [];
for (let i = 0; i < 500; i++) {
    const matchUUID = `match_${i.toString(16).padStart(8, '0')}-${Math.random().toString(16).substr(2, 4)}-4${Math.random().toString(16).substr(2, 3)}-${Math.random().toString(16).substr(2, 4)}-${Math.random().toString(16).substr(2, 12)}`;

    sessions.push({
        matchId: matchUUID,
        serverIp: `10.20.${Math.floor(i / 256)}.${i % 256}`,
        serverPort: 30000 + i,

        // TARGET: R6 Server Auth Token (32 chars hex uppercase)
        serverAuthToken: `R6S_SERVER_AUTH_${i.toString(16).toUpperCase().padStart(8, '0')}${Math.random().toString(16).toUpperCase().substr(2, 24)}`,

        status: ["LIVE", "WARMUP", "ENDING"][i % 3],
        map: ["Bank", "Consulate", "Oregon", "Clubhouse", "Villa", "Kafe"][i % 6],

        // Tokens de espectador admin
        spectators: i % 10 === 0 ? [`ADMIN_SPEC_${Math.random().toString(36).toUpperCase().substr(2, 20)}`] : [],

        created_at: new Date(Date.now() - (i * 1000))
    });
}

db.active_sessions.insertMany(sessions);
print(`[+] ${sessions.length} sessões inseridas`);

// Config com API keys
db.system_config.insertOne({
    service: "r6-matchmaking-api-v2",
    version: "2.4.1",
    db_connection_string: "mongodb://r6_admin:SuperSecretPass2024!@10.0.0.5:27017/r6_prod",
    api_keys: {
        analytics: `R6S_ANALYTICS_KEY_${Math.random().toString(36).substr(2, 40)}`,
        telemetry: `R6S_TELEMETRY_KEY_${Math.random().toString(36).substr(2, 40)}`,
        ubisoft_connect: `UPLAY_API_SECRET_${Math.random().toString(36).substr(2, 40)}`
    }
});

print("\n" + "=".repeat(70));
print("R6 MASSIVE SIMULATION DATABASE INITIALIZED");
print("=".repeat(70));
print(`Total Players: ${db.player_stats.countDocuments({})}`);
print(`Total Sessions: ${db.active_sessions.countDocuments({})}`);
print(`Total Config: ${db.system_config.countDocuments({})}`);
print("=".repeat(70));

// Mostrar exemplos de tokens alvo
print("\n[ALVOS] Exemplos de tokens a serem vazados:");
db.active_sessions.find().limit(3).forEach(function (s) {
    print(`  → ${s.serverAuthToken}`);
});

print("\n[!] Banco massivo pronto para CVE-2025-14847\n");
