# CVE-2025-14847 (MongoBleed) - PoC Funcional
## Exploração de Vazamento de Memória em MongoDB - Ataque R6 Simulado

<p align="center">
  <img src="https://img.shields.io/badge/CVE-2025--14847-critical?style=for-the-badge&logo=mongodb&logoColor=white" alt="CVE">
  <img src="https://img.shields.io/badge/MongoDB-7.0.5-red?style=for-the-badge&logo=mongodb" alt="MongoDB">
  <img src="https://img.shields.io/badge/Status-Exploit%20Funcional-success?style=for-the-badge" alt="Status">
  <img src="https://img.shields.io/badge/Taxa%20Sucesso-100%25-brightgreen?style=for-the-badge" alt="Taxa">
</p>

<p align="center">
  <strong>Prova de Conceito Completa para CVE-2025-14847 (MongoBleed)</strong><br>
  Tested: ✅ MongoDB 7.0.5 | 14.300+ Exploits Bem-Sucedidos | 4 UUIDs Vazados
</p>

---

## 🎯 Sobre o Projeto

Este repositório contém uma **Prova de Conceito (PoC) totalmente funcional** para a vulnerabilidade **CVE-2025-14847**, conhecida como **MongoBleed** uma falha crítica de divulgação de memória heap pré-autenticação em MongoDB.

### Contexto: O Incidente do Rainbow Six Siege

Em **Dezembro de 2025**, o jogo Rainbow Six Siege sofreu um ataque massivo que comprometeu ~50.000 contas de jogadores. A suspeita é que atacantes exploraram esta vulnerabilidade no MongoDB do backend para vazar:
- 🔑 Tokens de autenticação de servidor (`R6S_SERVER_AUTH_*`)
- 👤 UUIDs de jogadores e session IDs
- 🛡️ Flags de privilégios administrativos (`TOURNAMENT_ADMIN`, `DEV_BUILD_WHITELIST`)

Este PoC simula o ataque com dados realistas do R6.

---

## 🔥 Features

- ✅ **Exploit 100% Funcional** contra MongoDB 7.0.5
- ✅ **3 Ferramentas de Exploração**:
  - `poc.py` - Exploit principal com análise de padrões
  - `live_leaker.py` - Varredura incremental avançada
  - `popular_heap.py` - Script para popular heap com dados alvo
- ✅ **Ambiente Docker Completo** com MongoDB vulnerável
- ✅ **1500+ Documentos Simulados** do backend R6
- ✅ **Detecção Automática** de 10 padrões sensíveis (JWT, tokens, UUIDs, IPs)
- ✅ **Relatórios JSON** estruturados
- ✅ **Documentação Técnica Completa** (200+ páginas)

---

## 📊 Resultados Validados

| Métrica | Resultado |
|---------|-----------|
| **MongoDB Testado** | 7.0.5 (Vulnerável) |
| **Taxa de Sucesso** | **100%** (14.300/14.300 requisições) |
| **UUIDs Vazados** | 4 únicos |
| **Vazamentos Totais** | 33 strings distintas |
| **Maior Vazamento** | 176 bytes/requisição |
| **Padrões Detectados** | Network logs, UUIDs, system paths |

### UUIDs Extraídos (Prova Real)
```
246434ed-759b-4ce9-bb9c-2f520a9919b8
980ab3a7-0230-4718-aa2d-fb28feafd7f5
1052a310-4cdc-492f-9890-465d76baba9b
f20debfa-298d-48e3-b3b9-9a0e037c0fbd
```

---

## 🚀 Quick Start

### Pré-requisitos
- Docker & Docker Compose
- Python 3.8+

### Instalação

```bash
# Clone o repositório
git clone CVE-2025-14857-MongoBleed.git
cd MongoDBPoc

# Inicie o ambiente vulnerável
docker-compose up -d

# Aguarde inicialização (15-20s)
docker logs cve-2025-14847-lab | grep "R6 MASSIVE"
```

### Uso Básico

```bash
# 1. Popular heap com dados R6
python3 popular_heap.py 50

# 2. Verificar vulnerabilidade
python3 poc.py --target 127.0.0.1 --check

# 3. Explorar com live leaker (RECOMENDADO)
timeout 30 python3 live_leaker.py --host 127.0.0.1 --min 200 --max 3000 --save results.json
```

### Saída Esperada
```
[!] MongoBleed Live Leaker Avançado
[!] Alvo: 127.0.0.1:27017
[!] Faixa: doc_len 200 → 3000 (offset=500)

[*] Progresso: doc_len=245/3000 | Tentativas=100 | Taxa sucesso=100.0%

[!] PADRÕES R6 DETECTADOS (doc_len=245):
    [UUID] 1 novo(s):
      └─ 246434ed-759b-4ce9-bb9c-2f520a9919b8
```

---

## 🔬 Como Funciona

### Mecanismo da Vulnerabilidade

MongoDB permite compressão de mensagens via **zlib**. A vulnerabilidade está na validação inadequada do tamanho declarado vs. real:

```
Atacante → {compress: "zlib", uncompressedSize: 1MB, payload: <50 bytes>}
          ↓
Servidor aloca 1MB de heap  ← VULNERABILIDADE
          ↓
Servidor descomprime apenas 50 bytes
          ↓
Servidor retorna 1MB inteiro!
          └─ 50 bytes = dados reais
          └─ ~1MB - 50 = VAZAMENTO DE MEMÓRIA
```

### Código Vulnerável (Simplificado)
```cpp
// ANTES DO PATCH
size_t uncompressedSize = header.uncompressedSize;  // ← Controlado pelo atacante
buffer = malloc(uncompressedSize);                  // ← Aloca tamanho malicioso
zlib_decompress(compressed, buffer);
send(buffer, uncompressedSize);                     // ← VAZA BUFFER INTEIRO
```

---

## 📂 Estrutura do Projeto

```
MongoDBPoc/
├── poc.py                          # Exploit principal
├── live_leaker.py                  # Varredura incremental (✨ Recomendado)
├── popular_heap.py                 # Script de carga
├── docker-compose.yml              # MongoDB 7.0.5 vulnerável
├── init-db.js                      # 1000 players + 500 sessions R6
├── GUIA_TECNICO_COMPLETO.md       # Documentação detalhada (200+ páginas)
├── README.MD                       # Documentação em inglês
└── Portugues/                      # Versões traduzidas
    ├── poc_PT.py
    ├── README_PT.md
    └── GUIA_RAPIDO.md
```

---

## 🛡️ Versões Afetadas

| Série MongoDB | Versões Vulneráveis | Versão Corrigida |
|---------------|---------------------|------------------|
| **8.2.x** | 8.2.0 – 8.2.2 | 8.2.3 |
| **8.0.x** | 8.0.0 – 8.0.16 | 8.0.17 |
| **7.0.x** | 7.0.0 – 7.0.27 | 7.0.28 |
| **6.0.x** | 6.0.0 – 6.0.26 | 6.0.27 |
| **5.0.x** | 5.0.0 – 5.0.31 | 5.0.32 |
| **4.4.x** | 4.4.0 – 4.4.29 | 4.4.30 |
| **≤ 4.2** | Todas | Sem patch (EOL) |

---

## 🛡️ Detecção e Defesa

### Assinatura Snort
```snort
alert tcp any any -> any 27017 (
    msg:"CVE-2025-14847 MongoBleed Attempt";
    content:"|d4 07 00 00|";
    byte_test:4,>,1000000,4,little;
    sid:2025001;
)
```

### Configuração Segura (mongod.conf)
```yaml
net:
  bindIp: 127.0.0.1              # NUNCA 0.0.0.0!
  compression:
    compressors: []              # Desabilitar zlib

security:
  authorization: enabled
```

### Prioridades de Mitigação
1. 🔴 **CRÍTICO**: Atualizar para versão corrigida
2. 🟠 **ALTA**: Desabilitar compressão zlib
3. 🟠 **ALTA**: Segmentar rede (firewall)
4. 🟡 **MÉDIA**: Habilitar autenticação

---

## 📚 Documentação

- **[GUIA_TECNICO_COMPLETO.md](GUIA_TECNICO_COMPLETO.md)** - Análise técnica completa (200+ páginas)
  - Contexto do incidente R6
  - Mecanismo da vulnerabilidade
  - Código vulnerável vs. corrigido
  - Execução passo a passo
  - Resultados e estatísticas
  - IDS signatures e hardening

- **[README.MD](README.MD)** - Documentação principal (inglês)
- **[Portugues/](Portugues/)** - Versões traduzidas

---

## ⚠️ Aviso Legal

```
ESTA FERRAMENTA É APENAS PARA TESTES AUTORIZADOS E EDUCAÇÃO.

Uso não autorizado é ILEGAL e pode resultar em:
- Processos criminais (Lei 12.737/2012 no Brasil)
- Multas pesadas
- Prisão

Sempre obtenha PERMISSÃO POR ESCRITO antes de testar.
```

### Uso Permitido
- ✅ Testes de penetração com autorização por escrito
- ✅ Pesquisa acadêmica em ambientes isolados
- ✅ Verificação de patches de fornecedores
- ✅ Treinamento de equipes de segurança

### Uso Proibido
- ❌ Varredura ou ataque de sistemas sem permissão
- ❌ Acesso a bancos de dados de produção
- ❌ Venda ou weaponização deste código

---

## 🙏 Créditos

**Autor**: Ermenson Jr  
**Licença**: MIT (Uso Educacional)  
**Data**: Janeiro 2026  

### Referências
- [MongoDB Security Advisory](https://github.com/mongodb/mongo/commit/1264f9be5165abb0981f8023d2495652ab916699)
- [CVE-2025-14847 NVD](https://nvd.nist.gov/vuln/detail/CVE-2025-14847)
- [Akamai SIRT: MongoBleed Analysis](https://www.akamai.com/blog/security-research/cve-2025-14847-all-you-need-to-know-about-mongobleed)
- [Aikido Security](https://www.aikido.dev/blog/mongobleed-mongodb-zlib-vulnerability-cve-2025-14847)

---

## 📧 Contato

Para questões técnicas ou colaboração em pesquisas de segurança:
- **GitHub Issues**: Use a aba Issues deste repositório
- **Email Acadêmico**: Disponível no perfil do GitHub

---

## 🌟 Se Este Projeto Foi Útil

- ⭐ Dê uma estrela neste repositório
- 🔄 Compartilhe com a comunidade de segurança
- 📝 Cite em suas pesquisas acadêmicas
- 🐛 Reporte bugs ou melhorias via Issues

---

<p align="center">
  <sub>Desenvolvido para pesquisa em segurança ofensiva responsável.</sub><br>
  <sub>Não afiliado a Ubisoft, MongoDB Inc., ou Rainbow Six Siege.</sub>
</p>

<p align="center">
  <strong>🔒 Use com responsabilidade. Segurança é para todos. 🔒</strong>
</p>
