# MongoBleed-Pro ☠️

<p align="center">
  <img src="https://img.shields.io/badge/CVE-2025--14847-red?style=for-the-badge" alt="CVE">
  <img src="https://img.shields.io/badge/Python-3.8+-green?style=for-the-badge&logo=python" alt="Python">
  <img src="https://img.shields.io/badge/License-MIT-blue?style=for-the-badge" alt="License">
  <img src="https://img.shields.io/badge/Status-Active-brightgreen?style=for-the-badge" alt="Status">
</p>

<p align="center">
  <b>Advanced MongoDB Memory Leak Exploit Tool</b><br>
  <i>Keep Learning | Keep Hacking with CyberTechAjju</i>
</p>

---

## 🔥 About

**MongoBleed-Pro** is an advanced exploitation tool for **CVE-2025-14847**, a critical memory disclosure vulnerability in MongoDB's zlib compression handling. This tool allows security researchers to extract sensitive data from vulnerable MongoDB instances.

### ⚠️ Disclaimer

This tool is intended for **authorized security testing and educational purposes only**. Unauthorized access to computer systems is illegal. Always obtain proper authorization before testing.

---

## 💀 Vulnerability Details

| Property | Details |
|----------|---------|
| **CVE ID** | CVE-2025-14847 |
| **Vulnerability Type** | Memory Disclosure |
| **Affected Versions** | MongoDB < 8.0.10, < 7.3.6, < 7.0.19, < 6.0.23 |
| **Root Cause** | Buffer over-read in zlib decompression |
| **Impact** | Unauthenticated remote memory leak |

---

## 🚀 Features

- ☠️ **Hacker-Style UI** - Elite terminal interface with animations
- ⚡ **Multi-threaded Scanning** - Fast memory extraction with configurable threads
- 🎯 **Auto Vulnerability Detection** - Automatic vuln check before exploitation
- 🔑 **Secret Pattern Detection** - Finds AWS keys, API tokens, passwords, emails
- 📊 **Real-time Progress** - Live memory leak visualization
- 💾 **Data Export** - Saves extracted data to files for analysis
- 🌐 **Bulk Scanning** - Scan multiple targets from file

---

## 📦 Installation

```bash
# Clone the repository
git clone https://github.com/cybertechajju/CVE-2025-14847_Expolit.git
cd CVE-2025-14847_Expolit

# Install dependencies
pip install -r requirements.txt
```

---

## 🎮 Usage

### Basic Usage
```bash
python3 mongobleed_pro.py
```

### Target Specific Host
```bash
python3 mongobleed_pro.py --target 192.168.1.100
```

### Custom Port
```bash
python3 mongobleed_pro.py --target 192.168.1.100:27018
```

### Bulk Scanning
```bash
python3 mongobleed_pro.py --file targets.txt
```

### Advanced Options
```bash
python3 mongobleed_pro.py --target 192.168.1.100 --threads 100 --min-offset 100 --max-offset 20000
```

### All Options
| Argument | Description | Default |
|----------|-------------|---------|
| `--target` | Target IP/URL | Interactive prompt |
| `--file` | File with target list | None |
| `--threads` | Number of threads | 50 |
| `--min-offset` | Minimum memory offset | 20 |
| `--max-offset` | Maximum memory offset | 8192 |

---

## 📸 Screenshots

```
╔══════════════════════════════════════════════════════════════╗
║  💀 INITIATING MEMORY EXTRACTION SEQUENCE 💀                 ║
╚══════════════════════════════════════════════════════════════╝

⚡ Target Acquired: 192.168.1.100:27017
   ✓ Port OPEN
   ☠️  VULNERABLE! Initiating attack...

  ◉ 0x0E31 │ nr_inactive_anon 134420\nnr_active_anon 110832...
  ☠️  LOOT ACQUIRED: 🔐 Password
      → admin_pass=SuperSecret123

╔══════════════════ EXTRACTION COMPLETE ══════════════════╗
║  💾 Bytes Extracted: 125,847
║  📦 Unique Fragments: 342
║  🔑 Secrets Found: 5
╚══════════════════════════════════════════════════════════╝
```

---

## 🔑 Detected Secret Types

- 🔑 **AWS Access Keys** (AKIA...)
- 🤖 **OpenAI API Keys** (sk-...)
- 🐙 **GitHub Tokens** (ghp_...)
- 🔐 **Passwords & Secrets**
- 📧 **Email Addresses**

---

## 📁 Output Files

| File | Description |
|------|-------------|
| `loot_<host>.txt` | Extracted secrets in readable format |
| `dump_<host>.bin` | Raw memory dump for manual analysis |

---

## 🛡️ Mitigation

If you're a MongoDB administrator, update to patched versions:
- MongoDB 8.0.10+
- MongoDB 7.3.6+
- MongoDB 7.0.19+
- MongoDB 6.0.23+

---

## 👤 Author

**CyberTechAjju**
- 🐦 Twitter: [@CyberTechAjju](https://x.com/cybertechajju)

---

## 📜 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

---

## ⭐ Support

If you found this tool useful, please give it a ⭐ on GitHub!

---

<p align="center">
  <b>「 Keep Learning | Keep Hacking 」</b><br>
  <i>Made with ❤️ by CyberTechAjju</i>
</p>
