# CVE-2025-14558

FreeBSD rtsold DNSSL Command Injection (RCE)

## Description

`rtsold(8)` does not validate DNSSL domain names for shell metacharacters before passing them to `resolvconf(8)`. Command substitution via `$()` enables remote code execution from an adjacent network.

Affected: FreeBSD 13.x, 14.x, 15.x before 2025-12-16

## Usage

```bash
sudo python3 exploit.py -i eth0                      # touch /tmp/pwned
sudo python3 exploit.py -i eth0 -p 'id > /tmp/out'   # custom command
```

## Requirements

- Layer 2 adjacency to target
- Target: `rtsold` with `ACCEPT_RTADV` enabled
- Attacker: root, Python 3, Scapy

## References

- https://security.FreeBSD.org/advisories/FreeBSD-SA-25:12.rtsold.asc
- https://www.exploit-db.com/exploits/52463


Credits: Kevin Day
