# CVE-2025-14440
JAY Login &amp; Register &lt;= 2.4.01 - Authentication Bypass via Cookie
# 🚨 JAY Login & Register <= 2.4.01 - Authentication Bypass via Cookie

## 📝 Description

The **JAY Login & Register** plugin for WordPress is vulnerable to authentication bypass in versions **up to and including 2.4.01**.
This flaw arises due to incorrect authentication logic within the `jay_login_register_process_switch_back` function, which inadequately validates the value of the `jay_login_register_switched_from_user` cookie. As a result, *unauthenticated attackers* can exploit the vulnerability to log in as **any existing user**, including *administrators*, provided they know a valid user ID.

- **CVE:** CVE-2025-14440
- **CVSS:** 9.8 (Critical)

---

## 🚀 Script Overview

This script automates exploitation of CVE-2025-14440 by:

- ✔️ Extracting the required nonce for the "switch back" action from the target site
- ✔️ Allowing you to specify the user ID to target (e.g., administrator)
- ✔️ Crafting all necessary headers and cookies automatically
- ✔️ Sending the crafted authentication bypass request
- ✔️ Displaying and saving obtained session cookies for successful exploitation
- ✔️ Handling most common errors, user input issues, SSL verifications, and encoding problems

The code is structured for maximum reliability and clean output — making exploitation accessible to professionals and security researchers.

---

## 🛠️ Usage

```bash
python3 CVE-2025-14440.py -u <TARGET_URL> -id <USER_ID>
```

**Arguments:**
- `-u` or `--url`: Target site (can be with or without `http(s)://`)
- `-id` or `--id`: The user ID to exploit (e.g., `1` for administrator)

---

## 📈 Expected Output

- If exploitation is **successful**, you'll see:
  - The extracted session cookie printed on the screen, and
  - The site and associated cookie saved in `extracted_cookies.txt`
- If exploitation **fails** (site not vulnerable, invalid user ID, or patch applied), the script will notify you gracefully.
- All relevant status and error messages are clearly displayed.

---

## ⚠️ Disclaimer

> This script is provided **for educational and authorized penetration testing purposes only**.  
> The author is **not responsible for any misuse** or illegal activity carried out using this code.  
> **Always obtain permission** before testing any website, and respect applicable laws and ethical guidelines.

---

## 🙋‍♂️ Author

By: **Nxploited (Khaled Alenazi)**  
[GitHub](https://github.com/Nxploited) | [Telegram](https://t.me/Nxploited)
