# CVE-2025-14156
Fox LMS – WordPress LMS Plugin 1.0.4.7 - 1.0.5.1 - Unauthenticated Privilege Escalation via 'createOrder'
# ⚠️ CVE-2025-14156 – Fox LMS WordPress Unauthenticated Privilege Escalation Exploit

---

## 🛡️ Vulnerability Overview

**Fox LMS – WordPress LMS Plugin (v1.0.4.7 to v1.0.5.1) – Unauthenticated Privilege Escalation via `createOrder`**

All versions up to and including **1.0.5.1** of Fox LMS for WordPress are vulnerable to privilege escalation. The `/fox-lms/v1/payments/create-order` REST API endpoint does not properly validate the `'role'` parameter when creating new users, allowing unauthenticated attackers to create accounts with arbitrary roles, including Administrator.  
**CVE:** CVE-2025-14156  
**CVSS Score:** 9.8 (Critical)  
**Risk:** Complete site compromise.

---

## 🚀 Script Name

`CVE-2025-14156.py`

---

## 📦 Features

- Bypasses common WAFs and security headers.
- Handles all encoding and responses professionally.
- Checks for correct exploitation via session cookies.
- Rapid and robust error handling.
- Outputs only essential credentials upon success.

---

## 🧑‍💻 Usage

```bash
python CVE-2025-14156.py -help                  
```
```
usage: CVE-2025-14156.py [-h] -u URL

CVE-2025-14156 Exploit By: Nxploited | Telegram: @Nxploited | Github: Nxploited

options:
  -h, --help     show this help message and exit
  -u, --url URL  Target URL (e.g. https://victim.site)
```
---

## ⚙️ Run Example

```bash
python CVE-2025-14156.py -u https://victim.site
```

---

## 📝 Expected Output

Upon successful exploitation, the script will output only:

```
[+] Exploit Successful!
Username: nxploited
Password: Nxploited@2025Strong
```

If exploitation fails, only a concise error message will be shown.

---

## 📖 How It Works

- The script submits a POST request to the vulnerable REST API endpoint and injects the `'administrator'` role.
- If exploitation is successful, session cookies are set, confirming account creation and privilege escalation.
- Credentials for the new administrator account are provided immediately.

---

## ⚠️ Disclaimer

> **This tool is for educational and authorized testing purposes only. Any unauthorized use against systems without explicit permission is illegal. The author is not responsible for misuse, damage, or legal consequences resulting from use of this script. Always follow responsible disclosure practices and ensure you have written authorization before testing any target.**

---

## 📬 Contact

**Telegram:** [@Nxploited](@KNxploited)  
**Github:** [Nxploited](https://github.com/Nxploited)

---

## ✍️ _By:_ **Nxploited (Khaled Alenazi)**
