# PostGallery-CVE-Report
Disclosure for CVE-2025-13543


# CVE-2025-13543 - Vulnerability in PostGallery

This repository discloses a vulnerability discovered in [PostGallery <= 1.12.5](https://wordpress.org/plugins/postgallery/),WordPress plugin developed by rtowebsites.

## 🛠 Affected Version

- **Product**: PostGallery
- **Version**: <= 1.12.5
- **URL**: https://wordpress.org/plugins/postgallery/

---

## 🔒 Assigned CVE
| CVE ID            | Type                      | Component                | Impact                    |
|-------------------|---------------------------|--------------------------|---------------------------|
| CVE-2025-13543    |  Authenticated (Subscriber+) Arbitrary File Upload                |  lib/ajax-actions/imageUpload.php　  admin/PostGalleryUploader.php          | Unauthenticated attacker can upload arbitrary file     |  

---

## 🧾 Detailed a Description

### CVE-2025-13543 — Authenticated (Subscriber+) Arbitrary File Upload

 - **Affected Component**: PostGallery AJAX upload handler (`postgalleryAjaxUpload`) and `PostGalleryUploader` backend
 - **Attack Vector**: Authenticated (Subscriber+) Arbitrary File Upload via directory traversal.
 - **Trigger**: Any authenticated low-privileged user (such as a Subscriber) can upload arbitrary PHP files to attacker-controlled paths via directory traversal.

```
curl -k -X POST "http://localhost:8080/wp-admin/admin-ajax.php" \
  -H "Cookie: wordpress_logged_in_<hash>=<your_cookie>" \
  -F "action=postgalleryAjaxUpload" \
  -F "postid=1" \
  -F "uploadFolder=../../../" \
  -F "name=shell.php" \
  -F "file=@shell.php;type=application/x-php"
```

 - **Impact**: Any authenticated low-privileged user (such as a Subscriber) can upload arbitrary PHP files to attacker-controlled paths via directory traversal. This allows remote code execution in the context of the web server, leading to full site compromise, including modification of site content, exfiltration of `wp-config.php` and database credentials, deployment of persistent backdoors, and creation of rogue administrator accounts.

## ❓Reason for the vulnerability
- In `lib/ajax-actions/imageUpload.php`, enforce proper authorization (for example, require `current_user_can('upload_files')`) and validate a cryptographic nonce before processing uploads.
- In `admin/PostGalleryUploader.php`, strictly constrain `uploadFolder` to a known subdirectory of `wp-content/uploads/gallery`, reject any value containing `../` or absolute paths, and normalize paths before use.
- Use WordPress’ standard upload APIs such as `wp_handle_upload()` / `wp_check_filetype_and_ext()` and restrict uploads to a whitelist of non-executable media types, explicitly blocking `.php` and other executable extensions in web-accessible directories.

## ひとこと
こんなCTFみたいな脆弱性が存在するなんて...と思った。
任意ファイルアップロードだけでもやばいのに、ディレクトリトラバーサルがあるという絶望
脆弱性の再現がとても楽しかった。

## 🔍 Discoverer

**Name**: MooseLove  
**Role**: Independent security researcher / bug hunter  
**Contact**: Available upon request  

---

## 📚 References

- Product: https://wordpress.org/plugins/postgallery/

---

## ⚠️ License

This advisory is provided for public security awareness. Free to share with attribution.
