# CVE-2025-13486 Proof of Concept

A Proof of Concept (PoC) exploit for CVE-2025-13486, a Remote Code Execution vulnerability in the **Advanced Custom Fields: Extended (ACFE)** WordPress plugin.

## Vulnerability Overview

This vulnerability exists in ACFE versions 0.9.0.5 through 0.9.1.1, allowing unauthenticated attackers to execute arbitrary PHP functions via the `acfe/form/render_form_ajax` AJAX action. The plugin uses `call_user_func_array()` with user-supplied input without proper validation.

## Features

- **Verification Mode**: Safely verify if a target is vulnerable using `print_r` (non-destructive)
- **Exploitation Mode**: Create an administrator account on vulnerable WordPress installations
- **Automatic Nonce Extraction**: Automatically extracts required nonce from target WordPress site

## Requirements

```bash
pip install requests
```

## Usage

### Verify Vulnerability (Recommended First Step)

```bash
python poc.py -u http://target-site.com --verify
```

### Exploit (Create Admin User)

```bash
# With random credentials (displayed after execution)
python poc.py -u http://target-site.com

# With custom credentials
python poc.py -u http://target-site.com --user admin123 --password P@ssw0rd! --email admin@example.com
```

## Options

```
-u, --url       Target WordPress URL (required)
--verify        Only verify vulnerability (safer, uses print_r)
--user          Username to create (default: random)
--password      Password to set (default: random)
--email         Email address to set (default: random)
```

## Disclaimer

This PoC is provided for **educational and authorized security testing purposes only**. Unauthorized access to computer systems is illegal. Always obtain proper authorization before testing.

## References

- CVE-2025-13486
- Advanced Custom Fields: Extended WordPress Plugin
