# CVE-2025-13342 PoC

The Frontend Admin by DynamiApps plugin for WordPress is vulnerable to unauthorized modification of arbitrary WordPress options in all versions up to, and including, 3.28.20. This allows attackers to register users and set the default role to administrator. Exploitation becomes unauthenticated if a form created through Frontend Admin is publicly accessible (no login required). This is tested on Frontend Admin version 3.28.18.

Original vulnerability discoverer is [YC\_Infosec](https://www.wordfence.com/threat-intel/vulnerabilities/researchers/jeong-yu-chan)

![poc gif](./poc.gif)

Exploit requirements:
- test\_site - Base site of the target wordpress site
- test\_form - URL of the page where a form created through Frontend Admin plugin has been created and accessible. (This PoC assumes form is publicly accessible)

## Disclaimer
The release of this PoC is for research and educational purpose only. No further improvements will be done and is released as is. The author and researcher is not responsible for any damages due to exploitation of the unpatched wordpress plugin. 

## References: 
- https://nvd.nist.gov/vuln/detail/CVE-2025-13342
- https://www.wordfence.com/threat-intel/vulnerabilities/wordpress-plugins/acf-frontend-form-element/frontend-admin-by-dynamiapps-32820-unauthenticated-arbitrary-options-update
