# Flo-Forms-CVE-Report
Disclosure for CVE-2025-13159

# CVE-2025-13159 - Vulnerability in Flo Forms – Easy Drag & Drop Form Builder

This repository discloses a vulnerability discovered in [Flo Forms – Easy Drag & Drop Form Builder <= 1.0.43](https://wordpress.org/plugins/flo-forms/),WordPress plugin developed by flothemesplugins.

## 🛠 Affected Version

- **Product**: Flo Forms – Easy Drag & Drop Form Builder
- **Version**: v1.0.43
- **URL**: https://wordpress.org/plugins/flo-forms/

---

## 🔒 Assigned CVE
| CVE ID            | Type                      | Component                | Impact                    |
|-------------------|---------------------------|--------------------------|---------------------------|
| CVE-2025-13159    |  Unauthenticated Stored Cross-Site Scripting via SVG Upload                |  public/class-flo-forms-public.php            | Unauthenticated attacker can execute JS     |  

---

## 🧾 Detailed a Description

### CVE-2025-13159 — Unauthenticated Stored Cross-Site Scripting via SVG Upload

 - **Affected Component**: Flo Forms admin page
 - **Attack Vector**: Unauthenticated Stored Cross-Site Scripting via SVG Upload
 - **Trigger**: An attacker can inject malicious scripts into the admin interface by exploiting the flo_form_submit to store arbitrary scripts via SVG Upload.

```
curl -k -X POST "https://localhost:8080/wp-admin/admin-ajax.php" \
  -F 'action=flo_form_submit' \
  -F 'flo_fid=<your fid>' \
  -F 'flo-form-model={}' \
  -F 'flo-form-schema={"groups":[]}' \
  -F 'file=@XSS.svg;type=image/svg+xml'
```
※If the `fid` within the object does not exist, it will fail.

 - **Impact**: Stored scripts may be executed, posing a risk of serious harm such as account hijacking.

## ❓Reason for the vulnerability
The plugin expands WordPress’s allowed MIME types to include image/svg+xml and exposes an unauthenticated AJAX action (flo_form_submit) that accepts file attachments and passes them to media_handle_upload() without any SVG sanitization or capability checks. Uploaded SVGs are then served back as image/svg+xml and linked from the admin UI. When an administrator opens the attachment (directly, or via <object>/<iframe>), the browser interprets the SVG document and executes embedded scripts, resulting in stored XSS.
- Exclude SVG from the allowed MIME types.

## ひとこと
一ヵ月経過したが、まだパッチは公開されておらず、ダウンロード自体停止されている。
今回はPoCの再現がなかなか上手くいかず、1時間以上詰まったが結果的にXSS.svgの前にアットマーク(@)を付け忘れていたことが判明。
## 🔍 Discoverer

**Name**: MooseLove  
**Role**: Independent security researcher / bug hunter  
**Contact**: Available upon request  

---

## 📚 References

- Product: https://wordpress.org/plugins/flo-forms/

---

## ⚠️ License

This advisory is provided for public security awareness. Free to share with attribution.
