const express = require('express');
const bodyParser = require('body-parser');
const {JSONPath} = require('jsonpath-plus');
const path = require("path");

const app = express();
const port = 3000;

// Guestbook list
var message = {
    "Ethan": "Keep pushing forward, no matter what!",
    "Olivia": "Happiness is a choice, so choose it every day!",
    "Lucas": "Believe in yourself and anything is possible.",
    "Sophia": "Kindness is free, sprinkle it everywhere!",
    "Noah": "Never stop learning and growing.",
    "Isabella": "Dream big and work hard to make it real.",
    "Benjamin": "Success comes from consistency and effort.",
    "Emily": "A smile can brighten anyone’s day.",
    "Daniel": "Challenges make us stronger, embrace them!",
    "Ava": "Love yourself and be confident in who you are.",
    "299": "We are EQST Team."
}
 
// Middleware to parse JSON bodies
app.use(bodyParser.json());

app.use(express.static(path.join(__dirname, 'public')));

app.get('/', (req, res) => {
    res.sendFile(path.join(__dirname, "public", "index.html"));
});

app.get('/data', (req, res) => {
    res.send(message);
});

// POST endpoint to accept message and jsonpath
app.post('/query', (req, res) => {
    const { path } = req.body;
    if (!message || !path) {
        return res.status(400).json({ error: 'Both message and path are required.' });
    }
    try {
        const result = JSONPath({path, json:message});
        res.json({ result });
    } catch (error) {
        res.status(400).json({ error: 'Invalid JSONPath or message.', details: error.message });
    }
});

app.listen(port, () => {
    console.log(`Server is running on http://localhost:${port}`);
});