# CVE-2025-12735 expr-eval RCE Exploit

A security research tool for detecting and testing the CVE-2025-12735 vulnerability in the `expr-eval` and `expr-eval-fork` npm packages.

## ⚠️ Disclaimer

This tool is for **authorized security testing and educational purposes only**. Unauthorized access to computer systems is illegal. Only use this tool on systems you own or have explicit written permission to test.

## 📋 Overview

CVE-2025-12735 is a critical Remote Code Execution vulnerability in the `expr-eval` and `expr-eval-fork` npm packages. This vulnerability allows attackers to define arbitrary functions within the `context` object used by the parser, enabling injection of malicious code that executes system-level commands.

**CVSS Score:** 9.8 (Critical)  
**Affected Versions:** expr-eval-fork < 3.0.0  
**Fixed Version:** expr-eval-fork v3.0.0+

## 🔍 Features

- **Automated Detection:** Scans for expr-eval library usage in JavaScript files
- **Endpoint Discovery:** Automatically finds evaluation endpoints
- **Vulnerability Testing:** Tests for CVE-2025-12735 vulnerability
- **Command Execution:** Demonstrates RCE capability (for authorized testing)
- **Multi-threading Support:** Scan multiple targets in parallel
- **Proxy Support:** Bypass WAF/Cloudflare restrictions
- **JSON Export:** Detailed results in JSON format

## 📦 Installation

### Prerequisites

- Python 3.6 or higher
- pip (Python package manager)

### Quick Install

```bash
# Clone the repository
git clone https://github.com/AN5I/cve-2025-12735-expr-eval-rce.git
cd cve-2025-12735-expr-eval-rce

# Install dependencies
pip install -r requirements.txt

# Make script executable (optional)
chmod +x uknf_cve_2025_12735_expr_eval_rce.py
```

### Alternative: Direct Download

```bash
# Download the script
wget https://raw.githubusercontent.com/AN5I/cve-2025-12735-expr-eval-rce/main/uknf_cve_2025_12735_expr_eval_rce.py

# Install dependencies
pip install requests
```

## 🚀 Usage

### Basic Usage

```bash
# Single target
python3 uknf_cve_2025_12735_expr_eval_rce.py -u http://target.com

# Execute custom command
python3 uknf_cve_2025_12735_expr_eval_rce.py -u http://target.com -c "whoami"

# Multiple targets from file
python3 uknf_cve_2025_12735_expr_eval_rce.py -f targets.txt -o results.json

# With threading for faster scanning
python3 uknf_cve_2025_12735_expr_eval_rce.py -u http://target.com -t 5

# Verbose output for debugging
python3 uknf_cve_2025_12735_expr_eval_rce.py -u http://target.com -v
```

### Using Proxies

```bash
# Single proxy
python3 uknf_cve_2025_12735_expr_eval_rce.py -u http://target.com --proxy http://proxy:port

# Multiple proxies from file
python3 uknf_cve_2025_12735_expr_eval_rce.py -f targets.txt --proxy-list proxies.txt
```

### Command Line Options

```
-u, --url          Target URL
-f, --file         File containing target URLs (one per line)
-c, --command      Command to execute (default: id)
-t, --threads      Number of threads (default: 1)
-o, --output       Output file (default: uknf_expr_eval_results.json)
-v, --verbose      Enable verbose logging
--proxy            Proxy URL (e.g., http://127.0.0.1:8080)
--proxy-list       File containing proxy URLs (one per line)
```

## 📊 Output

The script generates a JSON file with detailed results:

```json
{
  "target": "http://target.com",
  "timestamp": "2025-11-20T15:35:32.638109",
  "expr_eval_detected": true,
  "vulnerable": true,
  "endpoint_found": true,
  "exploitation_successful": true,
  "command_executed": "id",
  "output": "uid=1000(user) gid=1000(user)...",
  "vulnerable_endpoint": "/api/evaluate"
}
```

## 🔬 How It Works

1. **Detection Phase:** Scans JavaScript files and HTML content for expr-eval references
2. **Endpoint Discovery:** Tests common API endpoints that might use expr-eval
3. **Vulnerability Testing:** Attempts to inject arbitrary functions in context object
4. **Exploitation:** If vulnerable, demonstrates RCE capability

## 🛡️ Mitigation

If you're using expr-eval or expr-eval-fork:

1. **Upgrade immediately:**
   ```bash
   npm install expr-eval-fork@latest
   ```

2. **Apply security patch:**
   - Apply [Pull Request #288](https://github.com/silentmatt/expr-eval/pull/288) to expr-eval
   - Or switch to expr-eval-fork v3.0.0+

3. **Implement input validation:**
   - Sanitize all user inputs
   - Use function whitelisting
   - Validate context objects

## 📚 References

- **CVE:** [CVE-2025-12735](https://www.cve.org/CVERecord?id=CVE-2025-12735)
- **CERT:** [VU#263614](https://kb.cert.org/vuls/id/263614)
- **GitHub Advisory:** [GHSA-jc85-fpwf-qm7x](https://github.com/advisories/GHSA-jc85-fpwf-qm7x)
- **Security Patch:** [PR #288](https://github.com/silentmatt/expr-eval/pull/288)

## 📖 Examples

### Example 1: Single Target Scan

```bash
python3 uknf_cve_2025_12735_expr_eval_rce.py -u https://example.com
```

### Example 2: Multiple Targets with Output

```bash
# Create targets file
echo "https://target1.com" > targets.txt
echo "https://target2.com" >> targets.txt

# Run scan
python3 uknf_cve_2025_12735_expr_eval_rce.py -f targets.txt -o results.json
```

### Example 3: Custom Command Execution

```bash
python3 uknf_cve_2025_12735_expr_eval_rce.py -u https://example.com -c "uname -a"
```

### Example 4: Using Proxies

```bash
# Single proxy
python3 uknf_cve_2025_12735_expr_eval_rce.py -u https://example.com --proxy http://127.0.0.1:8080

# Multiple proxies from file
echo "http://proxy1:8080" > proxies.txt
echo "http://proxy2:8080" >> proxies.txt
python3 uknf_cve_2025_12735_expr_eval_rce.py -f targets.txt --proxy-list proxies.txt
```

## 🤝 Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

1. Fork the repository
2. Create your feature branch (`git checkout -b feature/AmazingFeature`)
3. Commit your changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

## 🐛 Issues

If you encounter any issues or have suggestions, please open an issue on GitHub.

## 📝 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## ⭐ Star History

If you find this tool useful, please consider giving it a star on GitHub!

## ⚖️ Legal

This tool is provided for educational and authorized security testing purposes only. The authors are not responsible for any misuse or damage caused by this program. Users are responsible for ensuring they have proper authorization before testing any systems.

## 🙏 Acknowledgments

- Original vulnerability reporter: Jangwoo Choe (UKO)
- CERT Coordination Center for vulnerability disclosure
- GitHub Security and npm for security advisories

## 💰 Donations

If you find this tool useful and would like to support the project:

**Bitcoin (BTC):**
```
bc1qj95y35w8r2mw0u28zrm3dmxtzjkq258xdv8tzv
```

**Ethereum (ETH):**
```
0x3DC302a3f35F6cD1A03FF4982EcE0dE8fE1cEba7
```

Thank you for your support! 🙏
