# CVE-2025-12539
TNC Toolbox: Web Performance &lt;= 1.4.2 - Unauthenticated Sensitive Information Exposure to Privilege Escalation/cPanel Account Takeover

# 🚨 TNC Toolbox: Web Performance <= 1.4.2 - Unauthenticated Sensitive Information Exposure to Privilege Escalation/cPanel Account Takeover

## 🛡️ Description

**TNC Toolbox: Web Performance** plugin for WordPress suffers from an _Unauthenticated Sensitive Information Exposure_ vulnerability in all versions up to, and including, **1.4.2**. The plugin stores cPanel API credentials (hostname, username, and API key) insecurely in web-accessible files within the `wp-content` directory. These files are created by the vulnerable `Tnc_Wp_Toolbox_Settings::save_settings` function with no access controls, allowing unauthenticated attackers to retrieve credentials and escalate privileges—from cPanel account takeover to full hosting environment compromise via arbitrary file upload and remote code execution.

- **CVE:** CVE-2025-12539  
- **CVSS Score:** 10.0 (Critical)


## 🧩 Script Features

- Professional and precise version detection of TNC Toolbox plugin.
- Automated exploitation when a vulnerable version is detected (1.4.2 or lower).
- Secure HTTP session handling with advanced header simulation and SSL bypass options.
- Step-by-step output with realistic delays for human-like interaction.
- Robust exception handling for reliability.
- Clean, well-structured JSON report output.


## ⚡ Usage

```bash
python3 CVE-2025-12539.py -u https://target-site.com
```
_Options:_
- `--insecure` : Disable SSL verification (if the target uses self-signed certificates).
- `--timeout <seconds>` : Customize HTTP request timeout (default: 12 seconds).


## 🛠️ Requirements

- Python 3.7+
- `requests` package


## 📦 Output

- Human-readable, delayed step messages covering detection and exploitation status.
- Structured JSON report including:
  - Target URL  
  - Vulnerability status  
  - Detected plugin version  
  - Extracted cPanel credentials (username, API key, hostname)
  - Any errors encountered

Example output:
```json
{
  "tool": "CVE-2025-12539-exploit",
  "description": "CVE-2025-12539 Exploit Script by: Khaled Alenazi",
  "target": "https://target-site.com",
  "checked_at": "2025-11-11T11:57:12Z",
  "vulnerable": true,
  "found_version": "1.4.2",
  "threshold_version": "1.4.2",
  "configs": {
    "cpanel-username": "admin",
    "cpanel-api-key": "**********",
    "server-hostname": "host.target.com"
  },
  "errors": ""
}
```


## ⚖️ Disclaimer

This tool is for educational and authorized security testing purposes only. Usage against systems without explicit permission is strictly prohibited and may be illegal. The author accepts no liability for misuse or any resulting damages.


## 👤 Author & Contacts

- **GitHub**: [Nxploited](https://github.com/Nxploited)
- **Telegram**: [KNxploited](https://t.me/KNxploited)

---

**_By: Nxploited (Khaled Alenazi)_**
