# Usage Instructions - CVE-2025-12428 PoC

## Quick Start

### Option 1: Web Browser (Recommended)

1. **Ensure you have a vulnerable browser version:**
   - Google Chrome < 142.0.7444.59
   - Microsoft Edge (Chromium) < latest patch

2. **Open `exploit.html` in the vulnerable browser**

3. **Click "Run Basic Proof of Concept" or "Run Advanced Exploit"**

4. **Monitor the console output for:**
   - Browser crashes
   - Memory corruption errors
   - Unexpected type coercion
   - Invalid memory access warnings

### Option 2: Command Line (Node.js)

Note: Node.js V8 is typically patched, but you can test the code structure:

```bash
npm install  # (if needed)
node exploit.js
node test.js
```

## What to Look For

### Indicators of Successful Exploit

1. **Browser Crash**
   - Complete browser termination
   - "Aw, Snap!" error in Chrome
   - Process termination

2. **Console Errors**
   - Memory-related errors
   - Type confusion warnings
   - Unexpected exceptions

3. **Performance Issues**
   - Browser slowdown
   - High memory usage
   - Freezing/hanging

4. **Unexpected Behavior**
   - Wrong values returned
   - Type mismatches
   - Invalid operations succeeding

## Testing Environment Setup

### Isolated VM (Recommended)

1. Set up a virtual machine (VirtualBox, VMware, etc.)
2. Install vulnerable Chrome version
3. Disable network access
4. Run the PoC
5. Monitor for crashes

### Docker Container (Alternative)

```bash
# Run Chrome in isolated container
docker run -it --rm \
  -v $(pwd):/workspace \
  -e DISPLAY=$DISPLAY \
  chrome-vulnerable \
  /usr/bin/google-chrome /workspace/exploit.html
```

## Exploit Techniques Explained

### Basic PoC (`exploit.html`)
- Property accessor confusion
- Array index type confusion  
- Function type confusion
- Property descriptor manipulation
- Prototype chain manipulation

### Advanced Exploit (`advanced-exploit.js`)
- JIT optimization bypass
- Inline cache (IC) poisoning
- TypedArray view confusion
- Prototype pollution
- Advanced property manipulation

## Troubleshooting

### PoC Doesn't Trigger

1. **Check browser version:**
   ```javascript
   // Run in console
   navigator.userAgent
   ```

2. **Verify vulnerability:**
   - Ensure browser is actually vulnerable
   - Check if updates have been applied

3. **Try different techniques:**
   - Use "Advanced Exploit" button
   - Modify exploit parameters
   - Increase iteration counts

### Browser Crashes Immediately

- This is actually expected behavior if exploit succeeds!
- Document the crash
- Note which technique triggered it
- Check crash logs

### No Console Output

- Open browser DevTools (F12)
- Check console tab
- Verify JavaScript is enabled

## Responsible Disclosure

If you discover additional details about this vulnerability:

1. **Do NOT** publish full exploits publicly
2. **DO** report to browser vendors
3. **DO** follow responsible disclosure practices
4. **DO** help improve security

## Legal Disclaimer

This PoC is provided for:
- ✅ Security research
- ✅ Educational purposes
- ✅ Vulnerability assessment (authorized only)
- ✅ Security awareness

**NOT for:**
- ❌ Unauthorized access
- ❌ Malicious use
- ❌ Distribution to unauthorized parties
- ❌ Illegal activities

Use at your own risk. The authors assume no liability.

