# CVE-2025-12139: Integrate Google Drive WordPress Plugin - Information Disclosure Exploit

## Description
This is a Golang Proof of Concept (PoC) exploit for **CVE-2025-12139**.
The vulnerability exists in the **Integrate Google Drive** plugin (versions <= 1.5.3) for WordPress. 
It allows unauthenticated attackers to retrieve sensitive information, including **Google Client ID, Client Secret, and OAuth Access Tokens**, potentially leading to full Google Drive account takeover.

## Vulnerability Details
- **CVE:** CVE-2025-12139
- **Vulnerability Type:** Information Disclosure (via `wp_localize_script`)
- **Vendor:** SoftLab
- **Affected Version:** <= 1.5.3
- **Tested On:** Linux / Windows
- **Google Dork:** `inurl:"/wp-content/plugins/integrate-google-drive"`

## Proof of Concept
Here is the exploit in action, extracting sensitive Client ID and Secret Key:
![Exploit Output Screenshot](https://raw.githubusercontent.com/Galaxy-sc/CVE-2025-12139-WordPress-Integrate-Google-Drive-Exploit/refs/heads/main/proof.PNG)

## Usage

```bash
go run exploit.go -u https://target-site.com
```
