# CVE-2025-12101-checker

Simple Python PoC to check Citrix NetScaler ADC / Gateway instances for **CVE-2025-12101** (reflected XSS on `/cgi/logout`) using a crafted `SAMLResponse` + `RelayState` payload.

> ⚠️ **Use this tool only on systems you own or are explicitly authorized to test.**

---

## 🔍 Background

CVE-2025-12101 is a reflected Cross-Site Scripting vulnerability affecting NetScaler ADC and NetScaler Gateway when configured as a Gateway or AAA virtual server.

Under vulnerable configurations, the `/cgi/logout` endpoint processes SAML logout responses and may reflect attacker-controlled data from the `RelayState` parameter **without proper encoding**, leading to XSS.

Research and technical details come from watchTowr Labs:

- https://labs.watchtowr.com/is-it-citrixbleed4-well-no-is-it-good-also-no-citrix-netscalers-memory-leak-rxss-cve-2025-12101/?1

This repository provides a **minimal raw-TLS Python checker** that sends the same style of payload and inspects the HTTP response.

---

## 📥 Download

Clone the repository:

```bash
git clone https://github.com/6h4ack/CVE-2025-12101-checker.git
cd CVE-2025-12101-checker
```

Make sure you have **Python 3** installed.

---

## ▶️ Usage

The main script accepts a single required parameter: `-u` / `--url`.

```bash
python3 cve-2025-12101.py -u https://www.example.com
```

Also valid:

```bash
python3 cve-2025-12101.py -u www.example.com
python3 cve-2025-12101.py -u http://www.example.com
```

The URL is normalized internally; the script extracts the hostname and port (defaulting to `443` for HTTPS and `80` for HTTP).

---

## 🔎 Example Output

Example (for a vulnerable target):

```text
[*] Testing target: www.example.com:443

===== RAW HTTP RESPONSE BEGIN =====
HTTP/1.1 302 Object Moved
Content-Type: text/html
...
<script>alert(1)</script>
...
===== RAW HTTP RESPONSE END =====

[+] HTTP status code: 302
[+] Payload '<script>alert(1)</script>' reflected: True

[VULNERABLE] XSS confirmed on www.example.com with payload '<script>alert(1)</script)'
```

For a non-vulnerable target, you’ll see something like:

```text
[INFO] No XSS behaviour detected on www.example.com with this payload.
```

ANSI colors are used to make the result easier to see in the terminal (green for vulnerable, red for non-vulnerable / error conditions).

---

## ⚠️ Legal & Ethical Use

- Do **NOT** use this script against systems you do not own or do not have explicit written permission to test.
- Respect applicable laws, regulations, and your organization’s security policies.
- The author(s) of this repository are **not responsible** for any misuse or damage arising from the use of this code.

---

## 🙏 Credits

- Vulnerability research and original write-up: **watchTowr Labs**  
  https://labs.watchtowr.com/is-it-citrixbleed4-well-no-is-it-good-also-no-citrix-netscalers-memory-leak-rxss-cve-2025-12101/?1  
- This checker adapts their payload approach into a small raw-TLS Python PoC for quick verification.
